
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/rubi.zip" ),
        Asset( "ANIM", "anim/ghost_rubi_build.zip" ),
	Asset( "ANIM", "anim/perd_basic.zip" ),
	Asset( "ANIM", "anim/perd.zip" ),
}
local prefabs = {}
local start_inv = 
{
	"icestaff",
}

-- This initializes for both clients and the host
local common_postinit = function(inst) 
	-- choose which sounds this character will play
	inst.soundsname = "wendy"
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "rubi.tex" )
	inst:AddTag("insomniac")
	inst:AddTag("bookbuilder")
end


-- This initializes for the host only
local function master_postinit(inst)
	inst:AddComponent("reader")
	inst.components.locomotor.walkspeed = (4)
	inst.components.locomotor.runspeed = (6)
	inst.components.sanity:SetMax(200)
	inst.components.health:SetMaxHealth(80)
	inst.components.hunger:SetMax(100)
	inst.components.combat.damagemultiplier = .5
	inst.components.health:SetAbsorptionAmount(-0.5)
	inst.components.sanity.dapperness = TUNING.DAPPERNESS_MED
end



return MakePlayerCharacter("rubi", prefabs, assets, common_postinit, master_postinit, start_inv)
