local assets=
{
    Asset("ANIM", "anim/swap_firebag.zip"),
    Asset("IMAGE", "images/inventoryimages/ui_firebag_7x3.tex"),
    Asset("ATLAS", "images/inventoryimages/ui_firebag_7x3.xml"),
    Asset("IMAGE", "images/inventoryimages/firebag.tex"),
    Asset("ATLAS", "images/inventoryimages/firebag.xml"),
}
local prefabs = 
{
    "staffcastfx",
	"stafflight",
}

local function firefour(inst, owner)
     if owner:HasTag("fire1") and owner:HasTag("fire2") and owner:HasTag("fire3") and owner:HasTag("fire4") and owner:HasTag("fire5") then
        if inst:HasTag("firebag") then
        inst:RemoveTag("firebag")
        end
     else
        if (not inst:HasTag("firebag"))  and GetClock():IsDay() then
	inst:AddTag("firebag")
        end
     end
end

local function Onequip(inst, owner) 
	owner.AnimState:OverrideSymbol("swap_body", "swap_firebag", "backpack")
	owner.AnimState:OverrideSymbol("swap_body", "swap_firebag", "swap_body")
	owner.components.inventory.overflow = inst
	inst.components.container:Open(owner)
        owner:AddTag("fire4")
    inst.task = inst:DoPeriodicTask(0, function() firefour(inst, owner) end)
end

local function Onunequip(inst, owner) 
	owner.AnimState:ClearOverrideSymbol("swap_body")
	owner.AnimState:ClearOverrideSymbol("backpack")
	owner.components.inventory.overflow = nil
	inst.components.container:Close(owner)
        owner:RemoveTag("fire4")
inst.task:Cancel() inst.task = nil
	inst:AddTag("firebag")
end

local function OnOpen(inst)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/backpack_open", "open")
end

local function OnClose(inst)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/backpack_close", "open")
end



local slotpos = {}
for y = 0, 7 do

table.insert(slotpos, Vector3(3  -75, -y*75 + 265, 0))	
table.insert(slotpos, Vector3(3     , -y*75 + 265 ,0))	
table.insert(slotpos, Vector3(3  +75, -y*75 + 265 ,0))
	
end

local function fn(Sim)

	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("backpack1")
	inst.AnimState:SetBuild("swap_firebag") 

	inst.AnimState:PlayAnimation("anim")
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/firebag.xml"
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/backpack"
	
    inst:AddComponent("equippable")
	if EQUIPSLOTS["BACK"] then
		inst.components.equippable.equipslot = EQUIPSLOTS.BACK
	else
		inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	end

	inst.components.equippable:SetOnEquip( Onequip )
	inst.components.equippable:SetOnUnequip( Onunequip )
	
	inst:AddComponent("container")
	inst.components.container:SetNumSlots(#slotpos)
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetbgatlas = "images/inventoryimages/ui_firebag_7x3.xml"
	inst.components.container.widgetbgimage = "ui_firebag_7x3.tex"
        inst.components.container.widgetpos = Vector3(-100,-70,0)
	inst.components.container.widgetbgimagetint = {r=.98,g=.05,b=.10,a=1}
        inst.components.container.side_widget = true

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose

    inst:AddTag("firebag")

    inst:ListenForEvent( "daytime", function() inst:AddTag("firebag") end , GetWorld())
    inst:ListenForEvent( "dusktime", function() inst:RemoveTag("firebag") end , GetWorld()) 
    --inst:ListenForEvent( "nighttime", function() inst:RemoveTag("firebag") end , GetWorld())



	return inst
end

return Prefab( "common/inventory/firebag", fn, assets)
