local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe
TECH = GLOBAL.TECH
SpawnPrefab = GLOBAL.SpawnPrefab
Vector3	= GLOBAL.Vector3
TheSim = GLOBAL.TheSim

---------------------------------------------------------------------------------------------
STRINGS.NAMES.FIREBAG = "Firebag"
STRINGS.RECIPE_DESC.FIREBAG = "Take lots of things!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FIREBAG = "Now I can carry more with fire!"

PrefabFiles = 
{
	"firebag", 
}

function load()
	local firebag = GLOBAL.Recipe("firebag", {Ingredient("krampus_sack", 1), Ingredient("redgem", 2)}, RECIPETABS.MAGIC,  TECH.MAGIC_TWO)
	firebag.atlas = "images/inventoryimages/firebag.xml"
end
AddGamePostInit(load)

---------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------

local function firebagchange(inst)
    local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner or nil
    if owner and owner:HasTag("firebag") then
        local randomnumber = math.random()*100
        if randomnumber < 1 then
                local firebagdrop = SpawnPrefab("houndfire")
                local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)                
                firebagdrop.Transform:SetPosition(pt:Get()) 
			inst:Remove() 
        elseif randomnumber < 5 then 
		if inst.components.stackable then 
                              local thestacksize = inst.components.stackable.stacksize 
                              local themaxsize = inst.components.stackable.maxsize
	                      if thestacksize >= themaxsize then
                                     thestacksize = 3
                                         local firebagdrop = SpawnPrefab("redgem")
                                         local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)                
                                         firebagdrop.Transform:SetPosition(pt:Get())
			                 firebagdrop.components.stackable:SetStackSize(thestacksize)
                              elseif thestacksize >= (0.5 * themaxsize) then 
                                     thestacksize = 1
                                         local firebagdrop = SpawnPrefab("redgem")
                                         local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)                
                                         firebagdrop.Transform:SetPosition(pt:Get())
			                 firebagdrop.components.stackable:SetStackSize(thestacksize)
                              else 
                                         local firebagdrop = SpawnPrefab("ash")
                                         local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)                
                                         firebagdrop.Transform:SetPosition(pt:Get())
			                 firebagdrop.components.stackable:SetStackSize(thestacksize)
                              end 
                elseif randomnumber < 2 then     
                                         local firebagdrop = SpawnPrefab("redgem")
                                    thestacksize =1 
                                         local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)                
                                         firebagdrop.Transform:SetPosition(pt:Get())
			                 firebagdrop.components.stackable:SetStackSize(thestacksize)
                else
                                         local firebagdrop = SpawnPrefab("ash")
                                    thestacksize =1 
                                         local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)                
                                         firebagdrop.Transform:SetPosition(pt:Get())
			                 firebagdrop.components.stackable:SetStackSize(thestacksize)
		end
 			inst:Remove() 
        elseif randomnumber <20 then        
               local charcoalleft = SpawnPrefab("charcoal")
			local pt = Vector3(inst.Transform:GetWorldPosition())
			local holder = owner and ( owner.components.inventory or owner.components.container) 
			local slot = holder and holder:GetItemSlot(inst)			
			inst:Remove()
			if holder then
				holder:GiveItem(charcoalleft, slot)
			else
				charcoalleft.Transform:SetPosition(pt:Get())
			end
			
			if charcoalleft.components.stackable and inst.components.stackable then
				charcoalleft.components.stackable:SetStackSize(inst.components.stackable.stacksize)
			end
        elseif randomnumber <80 then
		local ashleft = SpawnPrefab("ash")
			local pt = Vector3(inst.Transform:GetWorldPosition())
			local holder = owner and ( owner.components.inventory or owner.components.container) 
			local slot = holder and holder:GetItemSlot(inst)			
			inst:Remove()
			if holder then
				holder:GiveItem(ashleft, slot)
			else
				ashleft.Transform:SetPosition(pt:Get())
			end
			
			if ashleft.components.stackable and inst.components.stackable then
				ashleft.components.stackable:SetStackSize(inst.components.stackable.stacksize)
			end

       end
   end
end

local function firebagashPrefabPostInit(inst)
    inst.task = inst:DoPeriodicTask(120, function() firebagchange(inst) end)
end

AddPrefabPostInit("log", firebagashPrefabPostInit)
AddPrefabPostInit("cutgrass", firebagashPrefabPostInit)
AddPrefabPostInit("twigs", firebagashPrefabPostInit)
AddPrefabPostInit("cutreeds", firebagashPrefabPostInit)
AddPrefabPostInit("poop", firebagashPrefabPostInit)
AddPrefabPostInit("guano", firebagashPrefabPostInit)
AddPrefabPostInit("armor_grass", firebagashPrefabPostInit)
AddPrefabPostInit("armor_wood", firebagashPrefabPostInit)
AddPrefabPostInit("beefalowool", firebagashPrefabPostInit)
AddPrefabPostInit("tentaclespots", firebagashPrefabPostInit)
AddPrefabPostInit("silk", firebagashPrefabPostInit)
AddPrefabPostInit("pigskin", firebagashPrefabPostInit)
AddPrefabPostInit("manrabbit_tail", firebagashPrefabPostInit)
AddPrefabPostInit("pinecone", firebagashPrefabPostInit)
AddPrefabPostInit("rope", firebagashPrefabPostInit)
AddPrefabPostInit("boards", firebagashPrefabPostInit)

AddPrefabPostInit("livinglog", firebagashPrefabPostInit)
AddPrefabPostInit("nightmarefuel", firebagashPrefabPostInit)
AddPrefabPostInit("strawhat", firebagashPrefabPostInit)

AddPrefabPostInit("fireflies", firebagashPrefabPostInit)
AddPrefabPostInit("lightbulb", firebagashPrefabPostInit)
AddPrefabPostInit("wall_hay_item", firebagashPrefabPostInit)
AddPrefabPostInit("wall_wood_item", firebagashPrefabPostInit)
AddPrefabPostInit("wall_stone_item", firebagashPrefabPostInit)

AddPrefabPostInit("papyrus", firebagashPrefabPostInit)
AddPrefabPostInit("bedroll_straw", firebagashPrefabPostInit)
AddPrefabPostInit("bedroll_furry", firebagashPrefabPostInit)
AddPrefabPostInit("bandage", firebagashPrefabPostInit)
AddPrefabPostInit("umbrella", firebagashPrefabPostInit)
AddPrefabPostInit("bugnet", firebagashPrefabPostInit)
AddPrefabPostInit("fishingrod", firebagashPrefabPostInit)
AddPrefabPostInit("nitre", firebagashPrefabPostInit)
AddPrefabPostInit("tophat", firebagashPrefabPostInit)
AddPrefabPostInit("beardhair", firebagashPrefabPostInit)
AddPrefabPostInit("feather_crow", firebagashPrefabPostInit)
AddPrefabPostInit("feather_robin", firebagashPrefabPostInit)
AddPrefabPostInit("feather_robin_winter", firebagashPrefabPostInit)
AddPrefabPostInit("dug_berrybush", firebagashPrefabPostInit)
AddPrefabPostInit("dug_grass", firebagashPrefabPostInit)
AddPrefabPostInit("dug_sapling", firebagashPrefabPostInit)
AddPrefabPostInit("dug_berrybush2", firebagashPrefabPostInit)
AddPrefabPostInit("spidereggsack", firebagashPrefabPostInit)
AddPrefabPostInit("turf_road", firebagashPrefabPostInit)
AddPrefabPostInit("turf_rocky", firebagashPrefabPostInit)
AddPrefabPostInit("turf_woodfloor", firebagashPrefabPostInit)
AddPrefabPostInit("turf_checkerfloor", firebagashPrefabPostInit)
AddPrefabPostInit("turf_carpetfloor", firebagashPrefabPostInit)
AddPrefabPostInit("turf_forest", firebagashPrefabPostInit)
AddPrefabPostInit("turf_marsh", firebagashPrefabPostInit)
AddPrefabPostInit("turf_grass", firebagashPrefabPostInit)
AddPrefabPostInit("turf_savanna", firebagashPrefabPostInit)
AddPrefabPostInit("turf_dirt", firebagashPrefabPostInit)
AddPrefabPostInit("turf_cave", firebagashPrefabPostInit)
AddPrefabPostInit("turf_fungus", firebagashPrefabPostInit)
AddPrefabPostInit("turf_sinkhole", firebagashPrefabPostInit)
AddPrefabPostInit("turf_underrock", firebagashPrefabPostInit)
AddPrefabPostInit("turf_mud", firebagashPrefabPostInit)


local function firebagchange2(inst)
    local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner or nil
    if owner and owner:HasTag("firebag") then
    inst.SoundEmitter:KillSound("hiss")
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")
    local explode = SpawnPrefab("explode_small")
    local pos = owner:GetPosition()
    explode.Transform:SetPosition(pos.x, pos.y, pos.z)
        owner.components.container:DropEverything()
                local houndfirenum = inst.components.stackable.stacksize
                for k = 1, houndfirenum do
                local firebagdrop = SpawnPrefab("houndfire")
                local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)                
                firebagdrop.Transform:SetPosition(pt:Get()) 
                end
        inst:Remove()
        owner:Remove()
    end
end


local function firebagexplodePrefabPostInit(inst)
    inst.task = inst:DoPeriodicTask(10, function() firebagchange2(inst) end)
end

AddPrefabPostInit("gunpowder", firebagexplodePrefabPostInit)
AddPrefabPostInit("slurtleslime", firebagexplodePrefabPostInit)