local assets=
{
	Asset("ANIM", "anim/krampuser_egg.zip"),
	Asset("IMAGE", "images/inventoryimages/krampuseregg.tex"),
	Asset("ATLAS", "images/inventoryimages/krampuseregg.xml"),
	Asset("IMAGE", "images/inventoryimages/krampuseregg_cracked.tex"),
	Asset("ATLAS", "images/inventoryimages/krampuseregg_cracked.xml"),
}


local prefabs = 
{
	"krampuseregg_cracked",
	"krampuser",
}

local loot_hot = 
{
    "krampuseregg",
}

local loot_cold = 
{
    "rockypet",
}

local function krampuserHatch(inst)
   
    local krampuser = SpawnPrefab("krampuser")
    krampuser.Transform:SetPosition(inst.Transform:GetWorldPosition())
    krampuser.components.health:SetPercent(0.05)
    inst:Remove()
end

local function krampuserCheckHatch(inst)
    if inst.playernear and inst.components.hatchable.state == "hatch" then
        krampuserHatch(inst)
    end
end

local function PlayUncomfySound(inst)
    inst.SoundEmitter:KillSound("uncomfy")
    if inst.components.hatchable.toohot then
        inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_hot_steam_LP", "uncomfy")
    elseif inst.components.hatchable.toocold then
        inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_cold_shiver_LP", "uncomfy")
    end
end

local function krampuserOnNear(inst)
    inst.playernear = true
    krampuserCheckHatch(inst)
end

local function krampuserOnFar(inst)
    inst.playernear = false
end

local function krampuserOnDropped(inst)
    inst.components.hatchable:StartUpdating()
    krampuserCheckHatch(inst)
    PlayUncomfySound(inst)
end

local function krampuserOnPutInInventory(inst)
    inst.components.hatchable:StopUpdating()
    inst.SoundEmitter:KillSound("uncomfy")
end

local function krampuserGetStatus(inst)
    if inst.components.hatchable then
        local state = inst.components.hatchable.state
        if state == "uncomfy" then
            if inst.components.hatchable.toohot then
                return "HOT"
            elseif inst.components.hatchable.toocold then
                return "COLD"
            end
        end
    end
end

local function DropLoot(inst)
    --print("tallbirdegg - DropLoot")
    
    inst:AddComponent("lootdropper")
    if inst.components.hatchable.toohot then
        inst.components.lootdropper:SetLoot(loot_hot)
    else
        inst.components.lootdropper:SetLoot(loot_cold)
    end
    inst.components.lootdropper:DropLoot()
end

local function krampuserOnHatchState(inst, state)
    --print("tallbirdegg - OnHatchState", state)
    
    inst.SoundEmitter:KillSound("uncomfy")

    if state == "crack" then
        local cracked = SpawnPrefab("krampuseregg_cracked")
        cracked.Transform:SetPosition(inst.Transform:GetWorldPosition())
        cracked.AnimState:PlayAnimation("crack")
        cracked.AnimState:PushAnimation("idle_happy", true)
        cracked.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_hatch_crack")
        inst:Remove()
    elseif state == "uncomfy" then
        if inst.components.hatchable.toohot then
            inst.AnimState:PlayAnimation("idle_hot", true)
        elseif inst.components.hatchable.toocold then
            inst.AnimState:PlayAnimation("idle_cold", true)
        end
        PlayUncomfySound(inst)
    elseif state == "comfy" then
        inst.AnimState:PlayAnimation("idle_happy", true)
    elseif state == "hatch" then
        krampuserCheckHatch(inst)
    elseif state == "dead" then

        if inst.components.hatchable.toohot then
            inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_hot_jump")
            inst:DoTaskInTime(20*FRAMES, function() inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_hot_explo") end)
            inst:DoTaskInTime(20*FRAMES, DropLoot)
            inst.AnimState:PlayAnimation("toohot")
        elseif inst.components.hatchable.toocold then
            inst:DoTaskInTime(15*FRAMES, function() inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_cold_freeze") end)
            inst:DoTaskInTime(30*FRAMES, DropLoot)
            inst.AnimState:PlayAnimation("toocold")
        end       
        inst:ListenForEvent("animover", function(inst) inst:Remove() end)

    end
end



local function commonfn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBuild("krampuser_egg")
    inst.AnimState:SetBank("egg")
    inst.AnimState:PlayAnimation("egg")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")

	inst.entity:AddSoundEmitter()

    inst.AnimState:PlayAnimation("egg")

    inst:AddComponent("hatchable")
    inst.components.hatchable:SetOnState(krampuserOnHatchState)
    inst.components.hatchable:SetCrackTime(TUNING.KRAMPUSER_HATCH_CRACK_TIME)
    inst.components.hatchable:SetHatchTime(TUNING.KRAMPUSER_HATCH_TIME)
    inst.components.hatchable:SetHatchFailTime(TUNING.KRAMPUSER_HATCH_FAIL_TIME)
    inst.components.hatchable:StartUpdating()


    inst.components.inventoryitem:SetOnDroppedFn(krampuserOnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(krampuserOnPutInInventory)

    inst.components.inspectable.getstatus = krampuserGetStatus

    inst.playernear = false
    
    return inst
end

local function krampusereggfn()
	local inst = commonfn()

    inst.components.inventoryitem.atlasname = "images/inventoryimages/krampuseregg.xml"

	return inst
end

local function krampusereggcrackedfn()
	local inst = commonfn()

    inst.components.hatchable.state = "comfy"
    inst.AnimState:PlayAnimation("idle_happy")

    inst:AddComponent("playerprox")
    inst.components.playerprox:SetDist(4, 6)
    inst.components.playerprox:SetOnPlayerNear(krampuserOnNear)
    inst.components.playerprox:SetOnPlayerFar(krampuserOnFar)
    
    inst.components.inventoryitem.atlasname = "images/inventoryimages/krampuseregg_cracked.xml"
    return inst
end



return Prefab( "common/inventory/krampuseregg", krampusereggfn, assets, prefabs),
		Prefab( "common/inventory/krampuseregg_cracked", krampusereggcrackedfn, assets)
