local assets =
{
	Asset("ANIM", "anim/armor_slurtleshell.zip"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function ProtectionLevels(inst, data)
    local equippedArmor = inst.components.inventory and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY)
    if data.statename == "shell_idle" or data.statename == "shell_hit" or data.statename == "shell_enter" then
        equippedArmor.components.armor:SetAbsorption(TUNING.FULL_ABSORPTION)
    else
        equippedArmor.components.armor:SetAbsorption(TUNING.ARMORSNURTLESHELL_ABSORPTION)
        equippedArmor.components.useableitem:StopUsingItem()
    end
end

local function shouldstopuse(inst, data)
    local equippedArmor = inst.components.inventory and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY)
    if equippedArmor and not (data.statename == "shell_idle" or data.statename == "shell_hit") then
        equippedArmor.components.useableitem:StopUsingItem()
        inst:RemoveEventCallback("newstate", shouldstopuse, inst)
        if inst.task then
            inst.task:Cancel()
            inst.task = nil
        end
    end
end

local function droptargets(inst)
    local pt = inst:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 20)

    for k,v in pairs(ents) do
        if v.components.combat and v.components.combat.target and v.components.combat.target == inst then
            v.components.combat:SetTarget(nil)
        end
    end

   if inst.task then
        inst.task:Cancel()
        inst.task = nil
    end
end

local function onuse(inst)
    local owner = inst.components.inventoryitem.owner
    if owner then
        owner.sg:GoToState("shell_enter")
        inst.task = inst:DoTaskInTime(5, function() droptargets(inst) end)
    end
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "armor_slurtleshell", "swap_body")
    inst:ListenForEvent("blocked", OnBlocked, owner)
    inst:ListenForEvent("newstate", ProtectionLevels, owner) 
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
    inst:RemoveEventCallback("newstate", ProtectionLevels, owner)

end



local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("armor_slurtleshell")
    inst.AnimState:SetBuild("armor_slurtleshell")
    inst.AnimState:PlayAnimation("anim")

    inst:AddComponent("inspectable")
local function OnDeploy (inst, pt)
    local snail = SpawnPrefab("armorsnurtleshell")
    snail.Transform:SetPosition(pt.x, pt.y, pt.z)
    snail.AnimState:SetBank("slurtle")
    snail.AnimState:SetBuild("slurtle")
    snail.AnimState:PlayAnimation("idle", true)
    snail.Transform:SetFourFaced()
    local sound = snail.entity:AddSoundEmitter()
    local brain = require "brains/leifbrain"
    snail:SetBrain(brain)
    snail:AddComponent("locomotor")
    snail.components.locomotor.walkspeed = 7
    snail:SetStateGraph("SGslurtle")
    local minimap = snail.entity:AddMiniMapEntity()
    minimap:SetIcon( "slurtle_den.png" )
    snail.components.inventoryitem:ChangeImageName("armorsnurtleshell")
    snail:RemoveComponent("armor")
    snail:RemoveComponent("equippable")
    snail:RemoveComponent("useableitem")
    snail:RemoveComponent("deployable")
    snail:RemoveTag("shell")
    snail:RemoveComponent("inventoryitem")
    snail:AddComponent("combat")
    snail:AddComponent("health")
    snail.components.health:SetMaxHealth(1000)
    snail.components.health:SetInvincible(true)
    snail.components.health.nofadeout = true
    snail.task = snail:DoPeriodicTask(math.random(8,12), function(snail)
        local pt1 = snail:GetPosition()
        local rocks = {"rock1","rock2","rock_flintless"}
        local rock = rocks[math.random(#rocks)]
        local newrock = SpawnPrefab(rock)
        newrock.Transform:SetPosition(pt1.x, 0, pt1.z)
        newrock.Physics:SetActive(false)
        newrock:DoTaskInTime(3, function(newrock) newrock.Physics:SetActive(true) end )
        SpawnPrefab("splash_ocean").Transform:SetPosition(pt1.x, 0, pt1.z)
        snail.SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
        GetPlayer().components.playercontroller:ShakeCamera(snail, "FULL", 0.2, 0.02, .25, 40)
    end )
    snail:AddComponent("inventoryitem")
    snail.components.inventoryitem:SetOnPutInInventoryFn(function(bull)
        snail:RemoveTag("sports")
        snail.components.locomotor:Stop()
        snail:SetBrain(nil)
        if snail.task then snail.task:Cancel() snail.task = nil end
    end )
    snail.components.inventoryitem:SetOnDroppedFn(function(snail)
        snail:AddTag("sports")
        local brain = require "brains/leifbrain"
        snail:SetBrain(brain)
        snail:RestartBrain()
        snail.task = snail:DoPeriodicTask(math.random(8,12), function(snail)
            local pt1 = snail:GetPosition()
            local rocks = {"rock1","rock2","rock_flintless"}
            local rock = rocks[math.random(#rocks)]
            local newrock = SpawnPrefab(rock)
            newrock.Transform:SetPosition(pt1.x, 0, pt1.z)
            newrock.Physics:SetActive(false)
            newrock:DoTaskInTime(3, function(newrock) newrock.Physics:SetActive(true) end )
            SpawnPrefab("splash_ocean").Transform:SetPosition(pt1.x, 0, pt1.z)
            snail.SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
            GetPlayer().components.playercontroller:ShakeCamera(snail, "FULL", 0.2, 0.02, .25, 40)
        end )
    end )
    snail:AddTag("sports")
    snail:AddTag("companion")
    snail:AddTag("snails")
    inst:Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy

local function onsave(inst, data)
    if inst:HasTag("snails") then
        data.snails = true
    end
    if inst:HasTag("sports") then
        data.sports = true
    end
end
local function onload(inst, data)
  if data and data.snails then
    inst.AnimState:SetBank("slurtle")
    inst.AnimState:SetBuild("slurtle")
    inst.AnimState:PlayAnimation("idle", true)
    inst.Transform:SetFourFaced()
    local sound = inst.entity:AddSoundEmitter()
    inst:AddComponent("locomotor")
    inst.components.locomotor.walkspeed = 7
    inst:SetStateGraph("SGslurtle")
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "slurtle_den.png" )
    inst.components.inventoryitem:ChangeImageName("armorsnurtleshell")
    inst:RemoveComponent("armor")
    inst:RemoveComponent("equippable")
    inst:RemoveComponent("useableitem")
    inst:RemoveComponent("deployable")
    inst:RemoveTag("shell")
    inst:RemoveComponent("inventoryitem")
    inst:AddComponent("combat")
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(1000)
    inst.components.health:SetInvincible(true)
    inst.components.health.nofadeout = true
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem:SetOnPutInInventoryFn(function(bull)
        inst:RemoveTag("sports")
        inst.components.locomotor:Stop()
        inst:SetBrain(nil)
        if inst.task then inst.task:Cancel() inst.task = nil end
    end )
    inst.components.inventoryitem:SetOnDroppedFn(function(inst)
        inst:AddTag("sports")
        local brain = require "brains/leifbrain"
        inst:SetBrain(brain)
        inst:RestartBrain()
        inst.task = inst:DoPeriodicTask(math.random(8,12), function(inst)
            local pt1 = inst:GetPosition()
            local rocks = {"rock1","rock2","rock_flintless"}
            local rock = rocks[math.random(#rocks)]
            local newrock = SpawnPrefab(rock)
            newrock.Transform:SetPosition(pt1.x, 0, pt1.z)
            newrock.Physics:SetActive(false)
            newrock:DoTaskInTime(3, function(newrock) newrock.Physics:SetActive(true) end )
            SpawnPrefab("splash_ocean").Transform:SetPosition(pt1.x, 0, pt1.z)
            inst.SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
            GetPlayer().components.playercontroller:ShakeCamera(inst, "FULL", 0.2, 0.02, .25, 40)
        end )
    end )
    inst:AddTag("companion")
    inst:AddTag("snails")
  end
  if data and data.sports then
    local brain = require "brains/leifbrain"
    inst:SetBrain(brain)
    inst:RestartBrain()
    inst.task = inst:DoPeriodicTask(math.random(8,12), function(inst)
        local pt1 = inst:GetPosition()
        local rocks = {"rock1","rock2","rock_flintless"}
        local rock = rocks[math.random(#rocks)]
        local newrock = SpawnPrefab(rock)
        newrock.Transform:SetPosition(pt1.x, 0, pt1.z)
        newrock.Physics:SetActive(false)
        newrock:DoTaskInTime(3, function(newrock) newrock.Physics:SetActive(true) end )
        SpawnPrefab("splash_ocean").Transform:SetPosition(pt1.x, 0, pt1.z)
        inst.SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
        GetPlayer().components.playercontroller:ShakeCamera(inst, "FULL", 0.2, 0.02, .25, 40)
    end )
    inst:AddTag("sports")
    local pt2 = GetPlayer():GetPosition()
    inst.Transform:SetPosition(pt2.x+1, 0, pt2.z+1)
  end
end
    inst.OnSave = onsave
    inst.OnLoad = onload
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/shellarmour"

    inst:AddTag("shell")

    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORSNURTLESHELL, TUNING.ARMORSNURTLESHELL_ABSORPTION)

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(onuse)



	return inst
end

return Prefab("common/inventory/armorsnurtleshell", fn, assets) 
