local TheSim = GLOBAL.TheSim
local Vector3 = GLOBAL.Vector3
local SpawnPrefab = GLOBAL.SpawnPrefab

local function TrapComponentPostInit(self)
    function self:Harvest(doer)
        if self.issprung then
            self.inst:PushEvent("harvesttrap")
            if self.onharvest then
                self.onharvest(self.inst)
            end
            
            local timeintrap = self.inst.components.timer and self.inst.components.timer:GetTimeElapsed("foodspoil")
            if self.lootprefabs and doer.components.inventory then
                for k,v in ipairs(self.lootprefabs) do
                    local loot = SpawnPrefab(v)
                    if loot then
                        doer.components.inventory:GiveItem(loot, nil, Vector3(TheSim:GetScreenPos(self.inst.Transform:GetWorldPosition())))
                        if loot.components.perishable and timeintrap then
                            loot.components.perishable:LongUpdate(timeintrap)
                        end
                    end
                end
            end
            self:Reset()
            self.inst:PushEvent("ondropped") -->-- MOD
        else                                 --<-- MOD
            if self.inst.components.finiteuses and self.inst.components.finiteuses:GetUses() > 0 then
                doer.components.inventory:GiveItem(self.inst, nil, Vector3(TheSim:GetScreenPos(self.inst.Transform:GetWorldPosition())))
            end
        end
    end
end

AddComponentPostInit("trap", TrapComponentPostInit)