
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
		Asset("ANIM", "anim/wes.zip"),
	Asset("ANIM", "anim/player_mime.zip"),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/cac.zip" ),
}

local prefabs ={}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "nosound"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "weston.tex" )

	-- todo: Add an example special power here.
	inst.components.combat.damagemultiplier = 1.5
	inst.components.health.maxhealth = 150
	inst.components.temperature.overheattemp = 1000
	inst.components.temperature.maxtemp = ( 10 )
	inst.components.eater.ignoresspoilage = true
	inst.components.health.fire_damage_scale = 3
	
	inst:AddTag("flower")
	
	inst.components.talker.colour = Vector3(128/255, 179/255, 95/255)
	
		inst.components.combat:SetDefaultDamage(50)
	local Combat = Class(function(self, inst)
	inst.components.combat.attackrange = 3
	inst.components.combat.hitrange = 2
	inst.components.combat.min_attack_period = 2
    end)
	
			inst.talksoundoverride = "dontstarve_dlc001/common/tumbleweed_choir"
			inst.hurtsoundoverride = "dontstarve/creatures/knight/sleep"
			inst.deathsoundoverride = "dontstarve_dlc001/common/HUD_hot_level1"

			inst:ListenForEvent("attacked", function(inst, data)

  if data.attacker and data.attacker.components.health then
   
   data.attacker.components.health:DoDelta(-15)
   
   end
   
end)

end

return MakePlayerCharacter("cac", prefabs, assets, fn)
