local Button = require "widgets/button"
local AnimButton = require "widgets/animbutton"
local ImageButton = require "widgets/imagebutton"
local TextButton = require "widgets/textbutton"
local Text = require "widgets/text"
local Image = require "widgets/image"
local Widget = require "widgets/widget"
local Menu = require "widgets/menu"

local TMI_inventorybar = require "widgets/TMI_inventorybar"

local function SendCommand(fnstr)
	local x, y, z = TheSim:ProjectScreenPos(TheSim:GetPosition())
	--[[local is_valid_time_to_use_remote = TheNet:GetIsClient() and TheNet:GetIsServerAdmin()
	if is_valid_time_to_use_remote then
		TheNet:SendRemoteExecute(fnstr, x, z)
	else]]
		ExecuteConsoleCommand(fnstr)
	
end

local TooManyItems = Class(Widget, function(self)
	Widget._ctor(self, "TooManyItems")
	self.IsTooManyItemsMenuShow =false

	self.root = self:AddChild(Widget("ROOT"))
	self.root:SetVAnchor(ANCHOR_MIDDLE)
	self.root:SetHAnchor(ANCHOR_MIDDLE)
	self.root:SetPosition(0,0,0)
	self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)

	self.shield = self.root:AddChild( Image("images/ui.xml", "black.tex") )
	self.shield:SetScale(1,1,1)
	self.shield:SetPosition(-345,0,0)
	self.shield:SetSize(350, 480)
	self.shield:SetTint(1,1,1,0.6)

	self.inv = self.shield:AddChild(TMI_inventorybar())
	self.inv:SetPosition(-127, 175, 0)

	self.healthbutton = self.shield:AddChild(ImageButton("images/healthmeter.xml", "healthmeter.tex", "healthmeter.tex", "healthmeter.tex"))
	self.healthbutton:SetTooltip("Health 100%")
	self.healthbutton:SetPosition(-130, -185, 0)
    self.healthbutton:SetScale(0.6)
	self.healthbutton:SetOnClick( function() SendCommand('GetPlayer().components.health:SetPercent(1)') end)

	self.sanitybutton = self.shield:AddChild(ImageButton("images/sanity.xml", "sanity.tex", "sanity.tex", "sanity.tex"))
	self.sanitybutton:SetTooltip("Sanity 100%")
	self.sanitybutton:SetPosition(-90, -185, 0)
    self.sanitybutton:SetScale(0.6)
	self.sanitybutton:SetOnClick( function() SendCommand('GetPlayer().components.sanity:SetPercent(1)') end)

	self.hungerbutton = self.shield:AddChild(ImageButton("images/hunger.xml", "hunger.tex", "hunger.tex", "hunger.tex"))
	self.hungerbutton:SetTooltip("Hunger 100%")
	self.hungerbutton:SetPosition(-50, -185, 0)
    self.hungerbutton:SetScale(0.6)
	self.hungerbutton:SetOnClick( function() SendCommand('GetPlayer().components.hunger:SetPercent(1)') end)

	self.moisturebutton = self.shield:AddChild(ImageButton("images/wetness_meter.xml", "wetness_meter.tex", "wetness_meter.tex", "wetness_meter.tex"))
	self.moisturebutton:SetTooltip("Wetness 0%")
	self.moisturebutton:SetPosition(-130, -220, 0)
    self.moisturebutton:SetScale(0.6)
	self.moisturebutton:SetOnClick( function() SendCommand('GetPlayer().components.moisture:SetMoistureLevel(0)') end)

	self.temperaturebutton = self.shield:AddChild(ImageButton("images/thermal_measurer_build.xml", "thermal_measurer_build.tex", "thermal_measurer_build.tex", "thermal_measurer_build.tex"))
	self.temperaturebutton:SetTooltip("20".."\176C")
	self.temperaturebutton:SetPosition(-90, -220, 0)
    self.temperaturebutton:SetScale(0.6)
	self.temperaturebutton:SetOnClick( function() SendCommand('GetPlayer().components.temperature:SetTemp(40)') end)

	self.beavernessbutton = self.shield:AddChild(ImageButton("images/logmeter.xml", "logmeter.tex", "logmeter.tex", "logmeter.tex"))
	self.beavernessbutton:SetTooltip("Log Meter 100%")
	self.beavernessbutton:SetPosition(-50, -220, 0)
    self.beavernessbutton:SetScale(0.6)
	self.beavernessbutton:SetOnClick( function() SendCommand('GetPlayer().components.beaverness:SetPercent(1)') end)

	self.godmodebutton = self.shield:AddChild(ImageButton("images/godmode.xml", "godmode.tex", "godmode.tex", "godmode.tex"))
	self.godmodebutton:SetTooltip("God Mode (On/Off)")
	self.godmodebutton:SetPosition(10, -185, 0)
    self.godmodebutton:SetScale(0.6)
	self.godmodebutton:SetOnClick( function() self:GodMode() end)

	self.creativemodebutton = self.shield:AddChild(ImageButton("images/creativemode.xml", "creativemode.tex", "creativemode.tex", "creativemode.tex"))
	self.creativemodebutton:SetTooltip("Creative Mode (On/Off)")
	self.creativemodebutton:SetPosition(70, -185, 0)
    self.creativemodebutton:SetScale(0.6)
	self.creativemodebutton:SetOnClick( function() SendCommand('GetPlayer().components.builder:GiveAllRecipes()') end)
	
	self.timepausebutton = self.shield:AddChild(ImageButton("images/pause.xml", "pause.tex", "pause.tex", "pause.tex"))
	self.timepausebutton:SetTooltip("Time Pause")
	self.timepausebutton:SetPosition(110, -185, 0)
    self.timepausebutton:SetScale(0.6)
	self.timepausebutton:SetOnClick( function() self:SetPause() end)

	self.continuebutton = self.shield:AddChild(ImageButton("images/continue.xml", "continue.tex", "continue.tex", "continue.tex"))
	self.continuebutton:SetTooltip("Continue")
	self.continuebutton:SetPosition(150, -185, 0)
    self.continuebutton:SetScale(0.6)
	self.continuebutton:SetOnClick( function() self:SetContinue() end)

	self.dayskipbutton = self.shield:AddChild(ImageButton("images/tweak.xml", "tweak.tex", "tweak.tex", "tweak.tex"))
	self.dayskipbutton:SetTooltip("Tweak Menu")
	self.dayskipbutton:SetPosition(70, -220, 0)
    self.dayskipbutton:SetScale(0.6)
	self.dayskipbutton:SetOnClick( function() self:TweakMenu() end)

	self.savebutton = self.shield:AddChild(ImageButton("images/save.xml", "save.tex", "save.tex", "save.tex"))
	self.savebutton:SetTooltip("Save Game")
	self.savebutton:SetPosition(110, -220, 0)
    self.savebutton:SetScale(0.6)
	self.savebutton:SetOnClick( function() SendCommand('GetPlayer().components.autosaver:DoSave()') end)

	self.cancelbutton = self.shield:AddChild(ImageButton("images/close.xml", "close.tex", "close.tex", "close.tex"))
	self.cancelbutton:SetTooltip("Close")
	self.cancelbutton:SetPosition(150, -220, 0)
    self.cancelbutton:SetScale(0.6)
	self.cancelbutton:SetOnClick( function() self:Close() end)

	self.tweakshield = self.root:AddChild( Image("images/ui.xml", "black.tex") )
	self.tweakshield:SetScale(1,1,1)
	self.tweakshield:SetPosition(-25, -155, 0)
	self.tweakshield:SetSize(290, 170)
	self.tweakshield:SetTint(1,1,1,0.6)
	self.tweakshield:Hide()
	self.tweakshield.IsTweakMenuShow =false
	
	self.season = self.tweakshield:AddChild(Text(DIALOGFONT, 32, "Season"))
	self.season:SetPosition(-5, 65, 0)
if IsDLCEnabled(CAPY_DLC) then
	self.mildbutton = self.tweakshield:AddChild(TextButton())
	self.mildbutton:SetFont(DIALOGFONT)
	self.mildbutton:SetText("Mild")
	self.mildbutton:SetTooltip("Mild Comes")
	self.mildbutton:SetPosition(-5, 30, 0)
	self.mildbutton:SetTextSize(24)
	self.mildbutton:SetColour(0.9,0.8,0.6,1)
	self.mildbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartMild()') end )

	self.wetbutton = self.tweakshield:AddChild(TextButton())
	self.wetbutton:SetFont(DIALOGFONT)
	self.wetbutton:SetText("Wet")
	self.wetbutton:SetTooltip("Wet Comes")
	self.wetbutton:SetPosition(-5, 0, 0)
	self.wetbutton:SetTextSize(24)
	self.wetbutton:SetColour(0.9,0.8,0.6,1)
	self.wetbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartWet()') end )

	self.greenbutton = self.tweakshield:AddChild(TextButton())
	self.greenbutton:SetFont(DIALOGFONT)
	self.greenbutton:SetText("Green")
	self.greenbutton:SetTooltip("Green Comes")
	self.greenbutton:SetPosition(-5, -30, 0)
	self.greenbutton:SetTextSize(24)
	self.greenbutton:SetColour(0.9,0.8,0.6,1)
	self.greenbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartGreen()') end)

	self.drybutton = self.tweakshield:AddChild(TextButton())
	self.drybutton:SetFont(DIALOGFONT)
	self.drybutton:SetText("Dry")
	self.drybutton:SetTooltip("Dry Comes")
	self.drybutton:SetPosition(-5, -60, 0)
	self.drybutton:SetTextSize(24)
	self.drybutton:SetColour(0.9,0.8,0.6,1)
	self.drybutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartDry()') end )
else
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	self.springbutton = self.tweakshield:AddChild(TextButton())
	self.springbutton:SetFont(DIALOGFONT)
	self.springbutton:SetText("Spring")
	self.springbutton:SetTooltip("Spring Comes")
	self.springbutton:SetPosition(-5, 30, 0)
	self.springbutton:SetTextSize(24)
	self.springbutton:SetColour(0.9,0.8,0.6,1)
	self.springbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartSpring()') end )

	self.autumnbutton = self.tweakshield:AddChild(TextButton())
	self.autumnbutton:SetFont(DIALOGFONT)
	self.autumnbutton:SetText("Autumn")
	self.autumnbutton:SetTooltip("Autumn Comes")
	self.autumnbutton:SetPosition(-5, -30, 0)
	self.autumnbutton:SetTextSize(24)
	self.autumnbutton:SetColour(0.9,0.8,0.6,1)
	self.autumnbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartAutumn()') end )

	self.summerbutton = self.tweakshield:AddChild(TextButton())
	self.summerbutton:SetFont(DIALOGFONT)
	self.summerbutton:SetText("Summer")
	self.summerbutton:SetTooltip("Summer Comes")
	self.summerbutton:SetPosition(-5, 0, 0)
	self.summerbutton:SetTextSize(24)
	self.summerbutton:SetColour(0.9,0.8,0.6,1)
	self.summerbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartSummer()') end)

	self.winterbutton = self.tweakshield:AddChild(TextButton())
	self.winterbutton:SetFont(DIALOGFONT)
	self.winterbutton:SetText("Winter")
	self.winterbutton:SetTooltip("Winter Comes")
	self.winterbutton:SetPosition(-5, -60, 0)
	self.winterbutton:SetTextSize(24)
	self.winterbutton:SetColour(0.9,0.8,0.6,1)
	self.winterbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartWinter()') end )
else
	self.summerbutton = self.tweakshield:AddChild(TextButton())
	self.summerbutton:SetFont(DIALOGFONT)
	self.summerbutton:SetText("Summer")
	self.summerbutton:SetTooltip("Summer Comes")
	self.summerbutton:SetPosition(-5, 0, 0)
	self.summerbutton:SetTextSize(24)
	self.summerbutton:SetColour(0.9,0.8,0.6,1)
	self.summerbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartSummer()') end)

	self.winterbutton = self.tweakshield:AddChild(TextButton())
	self.winterbutton:SetFont(DIALOGFONT)
	self.winterbutton:SetText("Winter")
	self.winterbutton:SetTooltip("Winter Comes")
	self.winterbutton:SetPosition(-5, -60, 0)
	self.winterbutton:SetTextSize(24)
	self.winterbutton:SetColour(0.9,0.8,0.6,1)
	self.winterbutton:SetOnClick( function() SendCommand('GetWorld().components.seasonmanager:StartWinter()') end )
end
end
	self.timecontrol = self.tweakshield:AddChild(Text(DIALOGFONT, 32, "Time"))
	self.timecontrol:SetPosition(-100, 65, 0)

	self.nextbutton = self.tweakshield:AddChild(TextButton())
	self.nextbutton:SetFont(DIALOGFONT)
	self.nextbutton:SetText("Next")
	self.nextbutton:SetTooltip("Next Phase")
	self.nextbutton:SetPosition(-100, 30, 0)
	self.nextbutton:SetTextSize(24)
	self.nextbutton:SetColour(0.9,0.8,0.6,1)
	self.nextbutton:SetOnClick( function() self:PhaseSkip() end )

	self.skip1daybutton = self.tweakshield:AddChild(TextButton())
	self.skip1daybutton:SetFont(DIALOGFONT)
	self.skip1daybutton:SetText("1 Day")
	self.skip1daybutton:SetTooltip("Skip 1 Day")
	self.skip1daybutton:SetPosition(-100, 0, 0)
	self.skip1daybutton:SetTextSize(24)
	self.skip1daybutton:SetColour(0.9,0.8,0.6,1)
	self.skip1daybutton:SetOnClick( function() self:DaySkipA() end )

	self.skip5daybutton = self.tweakshield:AddChild(TextButton())
	self.skip5daybutton:SetFont(DIALOGFONT)
	self.skip5daybutton:SetText("5 Days")
	self.skip5daybutton:SetTooltip("Skip 5 Days")
	self.skip5daybutton:SetPosition(-100, -30, 0)
	self.skip5daybutton:SetTextSize(24)
	self.skip5daybutton:SetColour(0.9,0.8,0.6,1)
	self.skip5daybutton:SetOnClick( function() self:DaySkipB() end )

	self.skip10daybutton = self.tweakshield:AddChild(TextButton())
	self.skip10daybutton:SetFont(DIALOGFONT)
	self.skip10daybutton:SetText("10 Days")
	self.skip10daybutton:SetTooltip("Skip 10 Days")
	self.skip10daybutton:SetPosition(-100, -60, 0)
	self.skip10daybutton:SetTextSize(24)
	self.skip10daybutton:SetColour(0.9,0.8,0.6,1)
	self.skip10daybutton:SetOnClick( function() self:DaySkipC() end )

	self.speedcontrol = self.tweakshield:AddChild(Text(DIALOGFONT, 32, "Speed"))
	self.speedcontrol:SetPosition(90, 65, 0)

	self.normalbutton = self.tweakshield:AddChild(TextButton())
	self.normalbutton:SetFont(DIALOGFONT)
	self.normalbutton:SetText("Normal")
	self.normalbutton:SetPosition(90, 30, 0)
	self.normalbutton:SetTextSize(24)
	self.normalbutton:SetColour(0.9,0.8,0.6,1)
	self.normalbutton:SetOnClick( function() SendCommand('c_speed(1)') end)

	self.fastbutton = self.tweakshield:AddChild(TextButton())
	self.fastbutton:SetFont(DIALOGFONT)
	self.fastbutton:SetText("Fast")
	self.fastbutton:SetPosition(90, 0, 0)
	self.fastbutton:SetTextSize(24)
	self.fastbutton:SetColour(0.9,0.8,0.6,1)
	self.fastbutton:SetOnClick( function() SendCommand('c_speed(5)') end)

	self.fasterbutton = self.tweakshield:AddChild(TextButton())
	self.fasterbutton:SetFont(DIALOGFONT)
	self.fasterbutton:SetText("Faster")
	self.fasterbutton:SetPosition(90, -30, 0)
	self.fasterbutton:SetTextSize(24)
	self.fasterbutton:SetColour(0.9,0.8,0.6,1)
	self.fasterbutton:SetOnClick( function() SendCommand('c_speed(15)') end)

	self.fastestbutton = self.tweakshield:AddChild(TextButton())
	self.fastestbutton:SetFont(DIALOGFONT)
	self.fastestbutton:SetText("Fastest")
	self.fastestbutton:SetPosition(90, -60, 0)
	self.fastestbutton:SetTextSize(24)
	self.fastestbutton:SetColour(0.9,0.8,0.6,1)
	self.fastestbutton:SetOnClick( function() SendCommand('c_speed(30)') end)
end)

function TooManyItems:GodMode()
	local fnstr = "c_godmode()"
	SendCommand(fnstr)
end

function TooManyItems:SetPause()
	SetPause(true, "console")
end

function TooManyItems:SetContinue()
	SetPause(false, "console")
end

function TooManyItems:PhaseSkip()
	GetClock():NextPhase()
end

function TooManyItems:DaySkipA()
	local player = GetPlayer()
	GetClock():MakeNextDay()
	player.components.hunger:SetPercent(1)
	player.components.sanity:SetPercent(1)
	player.components.health:SetPercent(1)
end

function TooManyItems:DaySkipB()
	local player = GetPlayer()
	for x = 1, 5 do GetClock():MakeNextDay() end
	player.components.hunger:SetPercent(1)
	player.components.sanity:SetPercent(1)
	player.components.health:SetPercent(1)
end

function TooManyItems:DaySkipC()
	local player = GetPlayer()
	for x = 1, 10 do GetClock():MakeNextDay() end
	player.components.hunger:SetPercent(1)
	player.components.sanity:SetPercent(1)
	player.components.health:SetPercent(1)
end

function TooManyItems:TweakMenu()
	if self.tweakshield.IsTweakMenuShow then
		self.tweakshield:Hide()
		self.tweakshield.IsTweakMenuShow =false
	else
		self.tweakshield:Show()
		self.tweakshield.IsTweakMenuShow =true
	end
end

function TooManyItems:Close()
	SetPause(false, "console")
	self:Hide()
	self.IsTooManyItemsMenuShow =false
end

function TooManyItems:OnControl(control, down)
	if TooManyItems._base.OnControl(self,control, down) then
		return true
	end

	if not down then
		if control == CONTROL_PAUSE or control == CONTROL_CANCEL then
			self:Close()
		end
	end

	return true
end

return TooManyItems
