Assets =
{
	Asset("IMAGE", "images/healthmeter.tex"),
	Asset("ATLAS", "images/healthmeter.xml"),
	Asset("IMAGE", "images/sanity.tex"),
	Asset("ATLAS", "images/sanity.xml"),
	Asset("IMAGE", "images/hunger.tex"),
	Asset("ATLAS", "images/hunger.xml"),
	Asset("IMAGE", "images/logmeter.tex"),
	Asset("ATLAS", "images/logmeter.xml"),
	Asset("IMAGE", "images/wetness_meter.tex"),
	Asset("ATLAS", "images/wetness_meter.xml"),
	Asset("IMAGE", "images/thermal_measurer_build.tex"),
	Asset("ATLAS", "images/thermal_measurer_build.xml"),
	Asset("ATLAS", "images/close.xml"),
	Asset("IMAGE", "images/close.tex"),
	Asset("ATLAS", "images/creativemode.xml"),
	Asset("IMAGE", "images/creativemode.tex"),
	Asset("ATLAS", "images/godmode.xml"),
	Asset("IMAGE", "images/godmode.tex"),
	Asset("ATLAS", "images/ui_tmi.xml"),
	Asset("IMAGE", "images/ui_tmi.tex"),
	Asset("ATLAS", "images/pause.xml"),
	Asset("IMAGE", "images/pause.tex"),
	Asset("ATLAS", "images/tweak.xml"),
	Asset("IMAGE", "images/tweak.tex"),
	Asset("ATLAS", "images/save.xml"),
	Asset("IMAGE", "images/save.tex"),
	Asset("ATLAS", "images/continue.xml"),
	Asset("IMAGE", "images/continue.tex"),
}

GetPlayer = GLOBAL.GetPlayer
GetClock = GLOBAL.GetClock
IsDLCEnabled = GLOBAL.IsDLCEnabled
REIGN_OF_GIANTS = GLOBAL.REIGN_OF_GIANTS
CAPY_DLC = GLOBAL.CAPY_DLC

---------------Load Cofig
local function GetConfig(s,default)
	local c=GetModConfigData(s)
	if c==nil then
		c=default
	end
	if type(c)=="table" then
		c=c.option_data
	end
	return c
end

GLOBAL.TooManyItems_KEYBOARD_TOGGLE_KEY = GetConfig("KEYBOARD_TOGGLE_KEY", 116)
GLOBAL.TooManyItems_TMI_L_CLICK_NUM = GetConfig("TMI_L_CLICK_NUM", 1)
GLOBAL.TooManyItems_TMI_R_CLICK_NUM = GetConfig("TMI_R_CLICK_NUM", 10)

local function IsDefaultScreen()
	return GLOBAL.TheFrontEnd:GetActiveScreen().name:find("HUD") ~= nil
end

local TMI = GLOBAL.require "widgets/TooManyItems"

local function ShowTMIMenu()
	-- Useless.
	--if GLOBAL.GetPlayer and GLOBAL.GetPlayer.HUD and GLOBAL.GetPlayer.HUD:IsChatInputScreenOpen() then return end

	if GetPlayer() and type(GetPlayer()) == "table" and GetPlayer().HUD and type(GetPlayer().HUD) == "table" and IsDefaultScreen() then
		if (controls or controls.containerroot) and controls.TMI then
			if controls.TMI.IsTooManyItemsMenuShow then
				controls.TMI:Hide()
				controls.TMI.IsTooManyItemsMenuShow = false
			else
				controls.TMI:Show()
				controls.TMI.IsTooManyItemsMenuShow = true
			end
		else
			print("[TooManyItems] Menu can not show!")
			return
		end
	end

end

local function AddTMI(self)
	controls = self -- this just makes controls available in the rest of the modmain's functions

	if controls then
		if controls.containerroot then
			controls.TMI = controls.containerroot:AddChild(TMI())
		else
			controls.TMI = controls:AddChild(TMI())
		end
	else
		print("[TooManyItems] AddClassPostConstruct errors!")
		return
	end

	controls.TMI:Hide()
	controls.TMI.IsTooManyItemsMenuShow = false

end

AddClassPostConstruct( "widgets/controls", AddTMI )
GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.TooManyItems_KEYBOARD_TOGGLE_KEY, ShowTMIMenu)