local MakePlayerCharacter = require "prefabs/player_common"


local assets = { Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/winter.zip" ),
		Asset( "ANIM", "anim/winterhalf.zip" ),		
		Asset( "ANIM", "anim/winterfull.zip" ),
}


local prefabs = 
{  
    
}

 
local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "winter"

	 local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "winter.tex" )

	-- todo: Add an example special power here.
	
	inst.components.health:SetMaxHealth(250)
	inst.components.hunger:SetMax(300)
	inst.components.sanity:SetMax(100)
	inst.components.combat.min_attack_period = 0.8
	inst.components.combat.damagemultiplier = 1.5
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.9)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.9)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.5)
    inst.components.eater.stale_health = .5
	
	
	inst.components.eater:SetCarnivore (true)
	
	
	
	inst:AddComponent("beard")
	inst.components.beard.bits = 39
	inst.AnimState:SetBuild("winterfull")
    inst.components.beard.onreset = function()
		inst.AnimState:SetBuild("winter")
    end
    inst.components.beard.prize = "beardhair"

    --tune the beard economy...
	local beard_days = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}
	local beard_bits = {6, 12, 17, 21, 24, 27, 30, 33, 36, 39}
	
    
    inst.components.beard:AddCallback(beard_days[1], function()
        inst.components.beard.bits = beard_bits[1]
		

    end)
    
    inst.components.beard:AddCallback(beard_days[2], function()
        inst.components.beard.bits = beard_bits[2]

    end)
    
    inst.components.beard:AddCallback(beard_days[3], function()
        inst.components.beard.bits = beard_bits[3]
		inst.AnimState:SetBuild("winterhalf")

    end)
	
	inst.components.beard:AddCallback(beard_days[4], function()
        inst.components.beard.bits = beard_bits[4]

    end)
	
	inst.components.beard:AddCallback(beard_days[5], function()
        inst.components.beard.bits = beard_bits[5]

    end)
	
    inst.components.beard:AddCallback(beard_days[6], function()
        inst.components.beard.bits = beard_bits[6]

    end)
    
    inst.components.beard:AddCallback(beard_days[7], function()
        inst.components.beard.bits = beard_bits[7]

    end)
    
    inst.components.beard:AddCallback(beard_days[8], function()
        inst.components.beard.bits = beard_bits[8]
		
    end)
	
	inst.components.beard:AddCallback(beard_days[9], function()
        inst.components.beard.bits = beard_bits[9]
		inst.AnimState:SetBuild("winterfull")
		
    end)
	
	inst.components.beard:AddCallback(beard_days[10], function()
        inst.components.beard.bits = beard_bits[10]

    end)
	
	
   end

-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.winter = "ëè"
STRINGS.CHARACTER_NAMES.winter = "Wynter"
STRINGS.CHARACTER_DESCRIPTIONS.winter = "*ǿıϵͳ\n*ݻƤݴ \n*Ҳֵȼ"
STRINGS.CHARACTER_QUOTES.winter = "\"....\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.WINTER = require "speech_winter"


return MakePlayerCharacter("winter", prefabs, assets, fn)
