local MakePlayerCharacter = require "prefabs/player_common"


local assets = { Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/wei.zip" ), }


local prefabs = 
{  
    
}

local start_inv = 
{
	"lantern",
	"trunkvest_summer",
	"fish_cooked",
	"fish_cooked",
	"fish_cooked",
	"fish_cooked",
	"fish_cooked",
	"fish_cooked",
	"fish_cooked",
	"fish_cooked",
	"fish_cooked",
	"fish_cooked",
	"trinket_9",
	"trinket_3"
}

 
local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wei"

	 local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "wei.tex" )

	-- todo: Add an example special power here.
	
	inst.components.health:SetMaxHealth(75)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(25)
	inst.components.combat.min_attack_period = 0.6
	inst.components.combat.damagemultiplier = 0.5
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.6)
	inst.components.sanity.night_drain_mult = 1.5
	inst.components.eater.stale_hunger = 0.2
    inst.components.eater.stale_health = 0
	
	inst.components.eater:SetCarnivore (true)
	
	local light = inst.entity:AddLight()
	    light:SetIntensity(.1)
		light:SetRadius(10)
		light:SetFalloff(1)
		light:Enable(true)
		light:SetColour(100/255, 130/255, 130/255)
	
	
	inst:AddComponent("beard")
    inst.components.beard.onreset = function()
        inst.AnimState:ClearOverrideSymbol("beard")
    end
    inst.components.beard.prize = "beardhair"
    
    --tune the beard economy...
	local beard_days = {5, 10, 15}
	local beard_bits = {1, 2, 3}
    
    inst.components.beard:AddCallback(beard_days[1], function()
        inst.components.beard.bits = beard_bits[1]

    end)
    
    inst.components.beard:AddCallback(beard_days[2], function()
        inst.components.beard.bits = beard_bits[2]

    end)
    
    inst.components.beard:AddCallback(beard_days[3], function()
        inst.components.beard.bits = beard_bits[3]

    end)
	
	
   end

-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.wei = "è"
STRINGS.CHARACTER_NAMES.wei = "Wei"
STRINGS.CHARACTER_DESCRIPTIONS.wei = "*ǵĺݣʹйԴ \n*ҹ\n*޷ܱʳ"
STRINGS.CHARACTER_QUOTES.wei = "\"\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.WEI = require "speech_wei"


return MakePlayerCharacter("wei", prefabs, assets, fn, start_inv)
