local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
GetPlayer = GLOBAL.GetPlayer


PrefabFiles = {
	"wisp",
	"wei",
	"winter",
}

Assets = {

	-- wisp

    Asset( "IMAGE", "images/saveslot_portraits/wisp.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wisp.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wisp.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wisp.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wisp_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wisp_silho.xml" ),

    Asset( "IMAGE", "bigportraits/wisp.tex" ),
    Asset( "ATLAS", "bigportraits/wisp.xml" ),
	
	Asset("IMAGE", "minimap/wisp.tex"),
    Asset("ATLAS", "minimap/wisp.xml"),
	
	Asset("SOUNDPACKAGE", "sound/wisp.fev"),
    Asset("SOUND", "sound/wisp.fsb"),
	
	
	-- wei
	
	
	Asset( "IMAGE", "images/saveslot_portraits/wei.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wei.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wei.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wei.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wei_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wei_silho.xml" ),

    Asset( "IMAGE", "bigportraits/wei.tex" ),
    Asset( "ATLAS", "bigportraits/wei.xml" ),
	
	Asset("IMAGE", "minimap/wei.tex"),
    Asset("ATLAS", "minimap/wei.xml"),
	
    Asset("SOUND", "sound/wei.fsb"),
	
	
	
	-- winter
	
	
	Asset( "IMAGE", "images/saveslot_portraits/winter.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/winter.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/winter.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/winter.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/winter_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/winter_silho.xml" ),

    Asset( "IMAGE", "bigportraits/winter.tex" ),
    Asset( "ATLAS", "bigportraits/winter.xml" ),
	
	Asset("IMAGE", "minimap/winter.tex"),
    Asset("ATLAS", "minimap/winter.xml"),
	
    Asset("SOUND", "sound/winter.fsb"),
	
	

}

RemapSoundEvent( "dontstarve/characters/wisp/death_voice", "wisp/wisp/death_voice" )
RemapSoundEvent( "dontstarve/characters/wisp/hurt", "wisp/wisp/hurt" )
RemapSoundEvent( "dontstarve/characters/wisp/talk_LP", "wisp/wisp/talk_LP" )

RemapSoundEvent( "dontstarve/characters/wei/death_voice", "wisp/wei/death_voice" )
RemapSoundEvent( "dontstarve/characters/wei/hurt", "wisp/wei/hurt" )
RemapSoundEvent( "dontstarve/characters/wei/talk_LP", "wisp/wei/talk_LP" )

RemapSoundEvent( "dontstarve/characters/winter/death_voice", "wisp/winter/death_voice" )
RemapSoundEvent( "dontstarve/characters/winter/hurt", "wisp/winter/hurt" )
RemapSoundEvent( "dontstarve/characters/winter/talk_LP", "wisp/winter/talk_LP" )

AddMinimapAtlas("minimap/wisp.xml")
AddMinimapAtlas("minimap/wei.xml")
AddMinimapAtlas("minimap/winter.xml")


local function ModMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "wisp" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
            appearsound = "dontstarve/maxwell/appear_adventure",
	    voice = "dontstarve/maxwell/talk_LP_world1",
		appearanim = "appear2",
		idleanim= "idle2_loop",
		dialogpreanim = "dialog2_pre",
		dialoganim="dialog2_loop",
		dialogpostanim = "dialog2_pst",
		disappearanim = "disappear2",
            disableplayer = true,
            skippable = false,
            {
                string = "Ŷƣ",
                wait = 2,
                anim = nil,
                sound = nil,
            },
			{
                string = "Ŷ",
                wait = 1,
                anim = nil,
                sound = nil,
            },
            {
                string = "ҿԷģѷ...",
                wait = 3,
                anim = dialog2_loop,
                sound = nil,
            },
	}
    end
	
	
	if GLOBAL.GetPlayer().prefab == "wei" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
            appearsound = "dontstarve/maxwell/appear_adventure",
	    voice = "dontstarve/maxwell/talk_LP_world1",
		appearanim = "appear2",
		idleanim= "idle2_loop",
		dialogpreanim = "dialog2_pre",
		dialoganim="dialog2_loop",
		dialogpostanim = "dialog2_pst",
		disappearanim = "disappear2",
            disableplayer = true,
            skippable = false,
            {
                string = "Ŷƣ",
                wait = 2,
                anim = nil,
                sound = nil,
            },
			{
                string = "Ŷ",
                wait = 1,
                anim = nil,
                sound = nil,
            },
            {
                string = "ҿԷģѷ...",
                wait = 3,
                anim = dialog2_loop,
                sound = nil,
            },
	}
    end

	
    if GLOBAL.GetPlayer().prefab == "winter" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
            appearsound = "dontstarve/maxwell/appear_adventure",
	    voice = "dontstarve/maxwell/talk_LP_world1",
		appearanim = "appear2",
		idleanim= "idle2_loop",
		dialogpreanim = "dialog2_pre",
		dialoganim="dialog2_loop",
		dialogpostanim = "dialog2_pst",
		disappearanim = "disappear2",
            disableplayer = true,
            skippable = false,
            {
                string = "Ŷƣ",
                wait = 2,
                anim = nil,
                sound = nil,
            },
			{
                string = "Ŷ",
                wait = 1,
                anim = nil,
                sound = nil,
            },
            {
                string = "ҿԷģѷ...",
                wait = 3,
                anim = dialog2_loop,
                sound = nil,
            },
	}
    end
	
end

AddPrefabPostInit("maxwellintro", ModMaxwellIntro)

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name

GLOBAL.STRINGS.CHARACTERS.wisp = {}
GLOBAL.STRINGS.CHARACTERS.wisp.DESCRIBE = {}

-- Let the game know Wod is a male, for proper pronouns during the end-game sequence.
-- Possible genders here are MALE, FEMALE, or ROBOT
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "Wisp")
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "Wei")
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "Winter")

AddModCharacter("wisp")
AddModCharacter("wei")
AddModCharacter("winter")