local assets =
{
	Asset("ANIM", "anim/fishinhole_mod.zip"),
}

local prefabs =
{
	"tropical_fish"
}

local FISH_STATES =
{
	FULL = "full",
	HALF = "half",
	GONE = "gone",
}

local function SetFishState(inst, state)
	inst.fish_state = state
end

local function GetFishState(inst)
	return inst.fish_state
end

local function PlayAnimation(inst, anim, loop)
	local state = inst:GetFishState()
	local anim = anim.."_"..state
	inst.AnimState:PlayAnimation(anim, loop)
end

local function PushAnimation(inst, anim, loop)
	local state = inst:GetFishState()
	local anim = anim.."_"..state
	inst.AnimState:PushAnimation(anim, loop)
end

local function getactiveperiod(inst)
	local activeTime = TUNING.TOTAL_DAY_TIME * 2

	local sm = GetSeasonManager()
	if sm:IsWetSeason() then
		activeTime = TUNING.TOTAL_DAY_TIME
	elseif sm:IsGreenSeason() then
		activeTime = TUNING.TOTAL_DAY_TIME * 3
	end

	return activeTime
end

local function getinactiveperiod(inst)
	local inactiveTime = TUNING.TOTAL_DAY_TIME

	local sm = GetSeasonManager()
	if sm:IsWetSeason() then
		inactiveTime = TUNING.TOTAL_DAY_TIME * 3
	elseif sm:IsGreenSeason() then
		inactiveTime = TUNING.TOTAL_DAY_TIME * 0.5
	end

	return inactiveTime
end

local function isbeingfished(inst)
	-- Am I currently being fished or does the player have a buffered action to fish me?
	local player = GetPlayer()
	local near = inst:IsNear(player,6)

	if near and player.sg.HasStateTag("fishing") then
		return true
	end

	local action = player:GetBufferedAction()
	if action and action.target and action.target == inst then
		return true
	end

	return false
end

local function onlongupdate(inst, dt)

	if inst.task ~= nil then
		inst.task:Cancel()
	end
end

local function onfishdelta(inst)
	local percent = inst.components.fishable:GetFishPercent()

	if percent >= 0.50 then
		inst:SetFishState(FISH_STATES.FULL)
	elseif percent > 0 then
		inst:SetFishState(FISH_STATES.HALF)
	elseif percent <= 0 then
		inst:SetFishState(FISH_STATES.GONE)
	end

	PushAnimation(inst, "idle_loop", true)

	-- if percent <= 0 then
	-- 	scatter(inst)
	-- end
end

local function onsave(inst, data)
	-- body
	if data == nil then
		data = {}
	end
end

local function onload(inst, data)

	if data then
		if data.fish_state then
			inst:SetFishState(data.fish_state)
		end
	end
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("idle")
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddPhysics()
    inst.entity:AddSoundEmitter()

    inst.Physics:SetCylinder(4, 2)
	inst.Physics:SetCollides(false) --Still will get collision callback, just not dynamic collisions.
	inst.Physics:SetCollisionGroup(COLLISION.OBSTACLES)
	inst.Physics:CollidesWith(COLLISION.CHARACTERS)

	inst:AddTag("aquatic")
    anim:SetBuild("fishinhole_mod")
    anim:SetBank("fishinhole_mod")
    anim:SetRayTestOnBB(true)

	anim:SetLayer( LAYER_BACKGROUND )
	anim:SetSortOrder( 3 )

	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "fishinhole_mod.tex" )

    inst:AddComponent("inspectable")
    inst.components.inspectable.nameoverride = "pond"
    inst.no_wet_prefix = true

	inst:AddComponent("fishable")
	inst.components.fishable:SetRespawnTime(TUNING.FISHING_HOLE_RESPAWN)
	inst.components.fishable:AddFish("tropical_fish")
	inst.components.fishable.OnFishDelta = onfishdelta
	local numFish = math.random(TUNING.FISHINGHOLE_MIN_FISH,TUNING.FISHINGHOLE_MAX_FISH)
	inst.components.fishable.maxfish = numFish
	inst.components.fishable.fishleft = numFish

	inst.active = true
	local activeTime = getactiveperiod()
	local inactiveTime = getinactiveperiod()
	local currentTime = math.random(0,activeTime + inactiveTime)
	local timeLeft

	inst.GetFishState = GetFishState
	inst.SetFishState = SetFishState
	inst:SetFishState(FISH_STATES.FULL)
	PlayAnimation(inst, "idle_loop", true)

	inst.OnLoad = onload
	inst.OnSave = onsave
	inst.OnLongUpdate = onlongupdate

	return inst
end

return Prefab( "common/objects/fishinhole_mod", fn, assets),
		MakePlacer( "common/fishinhole_mod_placer", "fishinhole_mod", "fishinhole_mod", "idle_loop_full" )