
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/No2bay.zip" ),
}
local prefabs = { "brscanno" }

local start_inv = { "brscanno","poop",}


local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wilson.png" )

	-- todo: Add an example special power here.
	--Top of the food chain

	inst.components.health.maxhealth = 200
	inst.components.sanity.max = 200
	inst.components.hunger:SetMax = 200
	inst.components.temperature.hurtrate = 10
	inst.components.builder.bonus_tech_level = 1
	inst.components.combat.damagemultiplier = 1.3

	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)

	inst.components.eater.ignoresspoilage = true


end

-- strings! Any "No2bay" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.No2bay = "վʳ˵"
STRINGS.CHARACTER_NAMES.No2bay = "˹"
STRINGS.CHARACTER_DESCRIPTIONS.No2bay = "*һʳ.\n*Զ˺.\n*ӦҰ."
STRINGS.CHARACTER_QUOTES.No2bay = "\".\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.No2bay = {}
STRINGS.CHARACTERS.No2bay.DESCRIBE = {}
STRINGS.CHARACTERS.No2bay.DESCRIBE.EVERGREEN = "A template description of a tree."



return MakePlayerCharacter("no2bay", prefabs, assets, fn , start_inv)
