local assets = {
	Asset("ANIM", "anim/punisher.zip"),
	Asset("ANIM", "anim/swap_punisher.zip"),

	Asset("ATLAS", "images/inventoryimages/punisher.xml"),
	Asset("IMAGE", "images/inventoryimages/punisher.tex"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_punisher", "punisher")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end

local function onattack_punisher(inst, attacker, victim)
	if victim ~= nil then
		local onepercent = inst.components.finiteuses.total / 100
		if (inst.components.finiteuses.current) < inst.components.finiteuses.total then
			inst.components.finiteuses:Use(-3)
		elseif (inst.components.finiteuses.current) == inst.components.finiteuses.total then
			inst.components.finiteuses:Use(-onepercent)
		end
	end
	if attacker and attacker.components.hunger then
		attacker.components.hunger:DoDelta(0)
	end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	inst.AnimState:SetBank("punisher")
	inst.AnimState:SetBuild("punisher")
	inst.AnimState:PlayAnimation("idle")  

	MakeInventoryPhysics(inst)

	inst:AddTag("sharp")

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
	inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)
	inst.components.finiteuses:SetOnFinished(inst.Remove)

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(68)
	inst.components.weapon:SetAttackCallback(onattack_punisher)

	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP, 3)
	inst.components.tool:SetAction(ACTIONS.MINE, 2)

	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)

	if IsDLCEnabled(REIGN_OF_GIANTS) then
		inst.components.equippable.dapperness = TUNING.CRAZINESS_SMALL
	else
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = TUNING.CRAZINESS_SMALL
	end

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "punisher"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/punisher.xml"

	return inst
end

return Prefab("common/inventory/punisher", fn, assets)
