local assets = {
	Asset("ANIM", "anim/armormosquito.zip"),
	Asset("ANIM", "anim/armormosquito2.zip"),

	Asset("ATLAS", "images/inventoryimages/armormosquito.xml"),
	Asset("IMAGE", "images/inventoryimages/armormosquito.tex"),
}

---
local function armorhealing(inst, owner)
	if owner == nil then
		return
	end
	local ownerHurt = owner and owner.components.hunger and owner.components.health and owner.components.health:IsHurt()
	local armorReady = inst.components.armor:GetPercent() ~= 0 and inst.heal_time == 1
	if ownerHurt and armorReady then
		owner.components.hunger:DoDelta(-3)
		owner.components.health:DoDelta(1, false, "armormosquito")
		inst.components.armor:TakeDamage(-20)
	end
end
---

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour") 
end

local function onequip(inst, owner) 
	owner.AnimState:OverrideSymbol("swap_body", "armormosquito", "swap_body")
	---
	inst.heal_time = 1
	if inst.heal_time == 1 then
		inst.task = inst:DoPeriodicTask(5, function() armorhealing(inst, owner) end)
	end
	---
	inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
	owner.AnimState:ClearOverrideSymbol("swap_body")
	---
	inst.heal_time = 0
	if inst.task ~= nil then
		inst.task:Cancel()
		inst.task = nil
	end
	---
	inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function mosquitoarmor()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("torso_hawaiian")
	inst.AnimState:SetBuild("armormosquito2")
	inst.AnimState:PlayAnimation("anim")

	inst.foleysound = "dontstarve/movement/foley/logarmour"

	inst:AddComponent("armor")
	inst.components.armor:InitCondition(10000, 0.80)

	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/armormosquito.xml"
	inst.components.inventoryitem.imagename = "armormosquito"

	inst.components.equippable.poisonblocker = true
	
	return inst
end

return Prefab("common/inventory/armormosquito", mosquitoarmor, assets)
