PrefabFiles = {
	"puck",
	"guts",
	"grenade",
	"punisher",
	"healthkit",
	"ewecushat",
	"ewecushatlight",
	"armormosquito",
}

Assets = {
	Asset( "ANIM", "anim/player_leap.zip" ),

	Asset( "IMAGE", "images/saveslot_portraits/guts.tex" ),
	Asset( "ATLAS", "images/saveslot_portraits/guts.xml" ),

	Asset( "IMAGE", "images/selectscreen_portraits/guts.tex" ),
	Asset( "ATLAS", "images/selectscreen_portraits/guts.xml" ),

	Asset( "IMAGE", "images/selectscreen_portraits/guts_silho.tex" ),
	Asset( "ATLAS", "images/selectscreen_portraits/guts_silho.xml" ),

	Asset( "IMAGE", "bigportraits/guts.tex" ),
	Asset( "ATLAS", "bigportraits/guts.xml" ),

	Asset( "IMAGE", "images/map_icons/guts.tex" ),
	Asset( "ATLAS", "images/map_icons/guts.xml" ),

	Asset( "IMAGE", "images/avatars/avatar_guts.tex" ),
	Asset( "ATLAS", "images/avatars/avatar_guts.xml" ),

	Asset( "IMAGE", "images/avatars/avatar_ghost_guts.tex" ),
	Asset( "ATLAS", "images/avatars/avatar_ghost_guts.xml" ),

	Asset( "IMAGE", "minimap/punisher.tex" ),
	Asset( "ATLAS", "minimap/punisher.xml" ),
}

local function ModMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "guts" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
            appearsound = "dontstarve/maxwell/disappear",
            voice = "dontstarve/maxwell/talk_LP",
            appearanim = "appear",
            idleanim= "idle",
            dialogpreanim = "dialog_pre",
            dialoganim="dial_loop",
            dialogpostanim = "dialog_pst",
            disappearanim = "disappear",
            disableplayer = true,
            skippable = true,
            {
                string = "Hey pal... I hope you don't hold a grudge against me?",
                wait = 3,
                anim = nil,
                sound = nil,
            },
			{
                string = "You know, I really need your help. I am traped in this hellhole and can't escape alone!",
                wait = 4,
                anim = nil,
                sound = nil,
            },
            {
                string = "I watched the duel between you and Bazuso at the Castle. You were magnificent!",
				wait = 4,
                anim = nil,
                sound = nil,
            },
			{
                string = "I am traped in the deepest part of this hell, you have to fight for our both lifes!",
				wait = 4,
                anim = nil,
                sound = nil,
            },
			{
                string = "Until then please don't cook Meatballs!",
				wait = 3,
                anim = nil,
                sound = nil,
            },
			
        }
    end
end
  
AddPrefabPostInit("maxwellintro", ModMaxwellIntro)


-- CHARACTER
modimport("scripts/character_guts.lua")

-- ITEM STRINGS
modimport("scripts/item_strings_guts.lua")

-- RECIPES
modimport("scripts/recipes_guts.lua")

-- LEAP MECHANIC
modimport("scripts/leapmechanic_guts.lua")
