
local assets=
{
    Asset("ANIM", "anim/witch_hat.zip"),
    Asset("ATLAS", "images/inventoryimages/witch_hat.xml")
}

        prefabs = {"forcefieldfx"}
 
    local function witch_hat_proc(inst, owner)
        inst:AddTag("forcefield")
        inst.components.armor:SetAbsorption(TUNING.FULL_ABSORPTION)
        local fx = SpawnPrefab("forcefieldfx")
        fx.entity:SetParent(owner.entity)
        fx.Transform:SetPosition(0, 0.2, 0)
        local fx_hitanim = function()
            fx.AnimState:PlayAnimation("hit")
            fx.AnimState:PushAnimation("idle_loop")
        end
        fx:ListenForEvent("blocked", fx_hitanim, owner)

        inst.components.armor.ontakedamage = function(inst, damage_amount)
            if owner then
                local sanity = owner.components.sanity
                if sanity then
                    local unsaneness = damage_amount * TUNING.ARMOR_WITCH_HAT_DMG_AS_SANITY
                    sanity:DoDelta(-unsaneness, false)
                end
            end
        end

        inst.active = true

        owner:DoTaskInTime(--[[Duration]] TUNING.ARMOR_WITCH_HAT_DURATION, function()
            fx:RemoveEventCallback("blocked", fx_hitanim, owner)
            fx.kill_fx(fx)
            if inst:IsValid() then
                inst:RemoveTag("forcefield")
                inst.components.armor.ontakedamage = nil
                inst.components.armor:SetAbsorption(TUNING.ARMOR_WITCH_HAT_ABSORPTION)
                owner:DoTaskInTime(--[[Cooldown]] TUNING.ARMOR_WITCH_HAT_COOLDOWN, function() inst.active = false end)
            end
        end)
    end

    local function tryproc(inst, owner)
        if not inst.active and math.random() < --[[ Chance to proc ]] TUNING.ARMOR_WITCH_HAT_PROC_CHANCE then
          witch_hat_proc(inst, owner)
        end
    end 

local function witch_hat_onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_hat", "witch_hat", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        inst.procfn = function() tryproc(inst, owner) end
        owner:ListenForEvent("attacked", inst.procfn)
end
 
local function witch_hat_onunequip(inst, owner)
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
        owner:RemoveEventCallback("attacked", inst.procfn)
end
 





	local function fn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    anim:SetBank("tophat")
    anim:SetBuild("witch_hat")
    anim:PlayAnimation("anim")    

    inst:AddComponent("armor")

    inst:AddTag("metal")         
    inst:AddTag("hat")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/witch_hat.xml"
    inst:AddComponent("tradable")

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.armor:InitCondition(TUNING.ARMOR_WITCH_HAT, TUNING.ARMOR_WITCH_HAT_ABSORPTION)

    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = (TUNING.DAPPERNESS_MED * 2)
     
    inst.components.equippable.walkspeedmult = 1.7     
    inst.components.equippable:SetOnEquip( witch_hat_onequip )
    inst.components.equippable:SetOnUnequip( witch_hat_onunequip )

     
    return inst
end
 
return Prefab( "common/inventory/witch_hat", fn or simple, assets, prefabs)