

local assets =
{
	Asset("ANIM", "anim/haunted_house.zip"),
        Asset("ANIM", "anim/witch_hat.zip"),
}

local prefabs = 
{
	 "ghost_1",
        "bat_1",
        "spiderden_1",
        "witch_hat", 
}

   local function onnear(inst)
	 GetClock():DoLightningLighting(4)
         GetSeasonManager():ForcePrecip (1)	
         inst.components.childspawner:StartSpawning()
         inst.components.periodicspawner:Start()
                local lightning = SpawnPrefab("lightning")
                local hound = SpawnPrefab("hound")
                local player = GetPlayer()
                local pos = player:GetPosition()
                pos.x = pos.x - 4
                pos.z = pos.z - 4
                hound.Transform:SetPosition(pos:Get())      
                lightning.Transform:SetPosition(pos:Get())
        inst.AnimState:PlayAnimation("near", true)
        inst.Light:Enable(true)

       --SpawnPrefab("spider_dropper").Transform:SetPosition(inst.Transform:GetWorldPosition(0,10,0))
       --SpawnPrefab("ghost").Transform:SetPosition(inst.Transform:GetWorldPosition(0,100,0))

	   end


local function onfar(inst)
       GetSeasonManager():StopPrecip()
       inst.AnimState:PlayAnimation("far", true)     
       inst.Light:Enable(false)
         inst.components.childspawner:StopSpawning()
         inst.components.periodicspawner:Stop()
       
end
       
local function	ReturnChildren(inst)
	inst.components.childspawner:StopSpawning()
	inst.components.childspawner:StartRegen()  
end




local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove("dropperweb", true)
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", false)
end



local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("idle", false)
        SpawnPrefab("dropperweb").Transform:SetPosition(inst.Transform:GetWorldPosition(0,100,0))
end



local function onsleep(inst, sleeper)

	if GetClock():IsDay() then
 if sleeper.components.talker then
			sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODAYSLEEP"))
			return
		end
	end
     

	
	local hounded = GetWorld().components.hounded

	local danger = FindEntity(inst, 10, function(target) return target:HasTag("monster") or target.components.combat and target.components.combat.target == inst end)
	
	if hounded and (hounded.warning or hounded.timetoattack <= 0) then
		danger = true
	end
	
	if danger then
		if sleeper.components.talker then
			sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODANGERSLEEP"))
		end
		return
	end
	
	sleeper.components.health:SetInvincible(true)
	sleeper.components.playercontroller:Enable(false)

	TheFrontEnd:Fade(false,1)

	inst:DoTaskInTime(1.2, function() 
	
		TheFrontEnd:Fade(true,1) 
		
		if GetClock():IsDay() then
                 if sleeper.components.talker then				
				sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODAYSLEEP"))
				sleeper.components.health:SetInvincible(false)
				sleeper.components.playercontroller:Enable(true)
				
                      return

			end
		end
		
		if sleeper.components.sanity then
			sleeper.components.sanity:DoDelta(-TUNING.SANITY_HUGE)
		end
		
		if sleeper.components.hunger then
			sleeper.components.hunger:DoDelta(-TUNING.CALORIES_HUGE, false, true)
		end
		
		if sleeper.components.health then
			sleeper.components.health:DoDelta(TUNING.HEALING_HUGE, false, "tent", true)
		end
		
		if sleeper.components.tempature then
			sleeper.components.tempature:SetTemperature(sleeper.components.tempature.maxtemp)
		end
		
		
		inst.components.finiteuses:Use()
		GetClock():MakeNextDay()

                local hat = SpawnPrefab("witch_hat")
                local player = GetPlayer()
                local pos = player:GetPosition()
                pos.x = pos.x + 1
                pos.z = pos.z + 1
                hat.Transform:SetPosition(pos:Get())

		
		sleeper.components.health:SetInvincible(false)
		sleeper.components.playercontroller:Enable(true)
		sleeper.sg:GoToState("wakeup")	
	end)
	
	
end	


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst:AddTag("tent")    
   
    MakeObstaclePhysics(inst, 6)    

    inst:AddTag("structure")
    anim:SetBank("haunted_house")
    anim:SetBuild("haunted_house")
    anim:PlayAnimation("idle")
    
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "haunted_house.tex" )	


	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = -TUNING.SANITYAURA_HUGE   

	
	inst:AddComponent( "childspawner" )
	inst.components.childspawner:SetMaxChildren(1)
	inst.components.childspawner.childname = "spiderden_1"
	inst.components.childspawner:SetRegenPeriod(300)

        inst.entity:AddGroundCreepEntity()
        inst.GroundCreepEntity:SetRadius( 15 )

    inst:AddComponent("periodicspawner")
    inst.components.periodicspawner:SetPrefab("ghost")
    inst.components.periodicspawner:SetRandomTimes(1,120)
    inst.components.periodicspawner:SetDensityInRange(30, 2)
    inst.components.periodicspawner:SetMinimumSpacing(1)
    --inst.components.periodicspawner:Start()

    local light = inst.entity:AddLight()
    inst.Light:Enable(false)
    inst.Light:SetRadius(6.5)
    inst.Light:SetFalloff(1)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(235/255,121/255,12/255)
    
    



    inst:AddComponent("inspectable")

    inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(1)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)

	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(500)
    inst.components.finiteuses:SetUses(500)
    inst.components.finiteuses:SetOnFinished( onfinished )
	    
		    
	inst:AddComponent("sleepingbag")
	inst.components.sleepingbag.onsleep = onsleep
	inst:AddComponent("burnable")
	--inst.components.burnable:AddBurnFX("pigtorch_flame", Vector3(-210,10,-00.1), "fire_marker")
	
        inst:AddComponent("fueled")
        inst.components.fueled.accepting = false
        inst.components.fueled.maxfuel = 999
        inst.components.fueled:SetSections(1)
          
        inst.components.fueled:SetUpdateFn( function()  
        if GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.PIGTORCH_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 01
        end
        
        if inst.components.burnable and inst.components.fueled then
        inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(),                 inst.components.fueled:GetSectionPercent())
        end
    end)
    
        inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            --inst.components.burnable:Extinguish()
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
        end
    end)
    
    
 

inst:AddComponent( "playerprox" )
       inst.components.playerprox:SetDist(10,17)
       inst.components.playerprox:SetOnPlayerNear(onnear)
       inst.components.playerprox:SetOnPlayerFar(onfar)	
	inst:ListenForEvent( "onbuilt", onbuilt)

       return inst
       end

return Prefab( "common/haunted_house", fn, assets, prefabs),
		MakePlacer( "common/haunted_house_placer", "haunted_house", "haunted_house", "near") 
