
local general = {
	"flotsam",
	"spiderden",
	"spiderden_2",
	"spiderden_3",
	"spiderhole",
	"slurtlehole",
	"catcoonden",
	"wallyintro_debris_1",
	"wallyintro_debris_2",
	"wallyintro_debris_3",
	"wallyintro_shipmast",
	"crate"
}

local tracks = {
	"animal_track",
	"dirtpile",
	"whale_bubbles"
}

local bones = {
	"houndbone", 
	"skeleton"
}

local holes = {
	"molehill",
	"rabbithole",
	"crabhole"
}

local things = {
	"teleportato_box",
	"teleportato_crank",
	"teleportato_potato",
	"teleportato_ring"
}

local walls = {
	"sandbagsmall",
	"wall_hay",
	"wall_limestone",
	"wall_ruins",
	"wall_stone",
	"wall_wood"
}

local vegetation = {
	"green_mushroom",
	"blue_mushroom",
	"red_mushroom",
	"carrot_planted",
	"seeds"
}

local pigs_rituals = {
	"pigtorch",
	"pighead",
	"mermhead",
	"wildborehead"
}

local chester_packim_bones = {
	"chester_eyebone",
	"packim_fishbone"
}

local tools = {
	"axe",
	"goldenaxe",
	"axe_obsidian",
	"pickaxe",
	"goldenpickaxe",
	"shovel",
	"goldenshovel",
	"machete",
	"goldenmachete",
	"machete_obsidian",
	"hammer",
	"pitchfork",
	"razor"
}

local minerals = {
	"flint",
	"rock2",
	"rocks",
	"goldnugget",
	"obsidian",
	"sandhill"
}

local flowers = {
	"flower"
}

local seashells = {
	"seashell_beached"
}

local basic_mobs = {
	"babybeefalo",
	"beefalo",
	"bishop",
	"catcoon",
	"chester",
	"deer",
	"deer_blue",
	"deer_red",
	"doydoy",
	"doydoybaby",
	"firehound",
	"glommer",
	"grassgekko",
	"hound",
	"hutch",
	"icehound",
	"jellyfish_planted",
	"knight",
	"knightboat",
	"koalefant_summer",
	"koalefant_winter",
	"krampus",
	"lightninggoat",
	"mandrake",
	"mandrake_active",
	"mandrake_planted",
	"minotaur",
	"musselfarm",
	"musselfarm_seed",
	"packim",
	"pigman",
	"rainbowjellyfish_planted",
	"rocky",
	"rook",
	"sharkitten",
	"sharx",
	"slurper",
	"slurtle",
	"snurtle",
	"solofish",
	"spat",
	"stungray",
	"swordfish",
	"tentacle",
	"tigershark",
	"walrus",
	"warg",
	"whale_blue",
	"whale_carcass_blue",
	"whale_carcass_white",
	"whale_white",
	"wildbore",
	"worm"
}

local giants = {
	"antlion",
	"bearger",
	"deerclops",
	"dragonfly",
	"kraken",
	"leif",
	"leif_sparse",
	"moose",
	"treeguard",
	"twister",
	"twister_seal"
}

local more_mobs = {
	"abigail",
	"ballphin",
	"bat",
	"bee",
	"birchnutdrake",
	"bunnyman",
	"butterfly",
	"canary",
	"canary_poisoned",
	"cormorant",
	"crab",
	"crawlinghorror",
	"crawlingnightmare",
	"crow",
	"dragoon",
	"eyeplant",
	"fireflies",
	"flup",
	"frog",
	"ghost",
	"killerbee",
	"kraken_tentacle",
	"lavae",
	"lavae_pet",
	"little_walrus",
	"merm",
	"mermfisher",
	"mole",
	"monkey",
	"mosquito",
	"mosquito_poison",
	"mossling",
	"nightmarebeak",
	"parrot",
	"perd",
	"pirateghost",
	"primeape",
	"rabbit",
	"robin",
	"robin_winter",
	"seagull",
	"snake",
	"snake_poison",
	"spider",
	"spiderqueen",
	"spider_dropper",
	"spider_hider",
	"spider_spitter",
	"spider_warrior",
	"stalker",
	"stalker_atrium",
	"stalker_forest",
	"stalker_minion1",
	"stalker_minion2",
	"swimminghorror",
	"tallbird",
	"tentacle_pillar",
	"terrorbeak",
	"toucan"
}

Assets = {}

function AddIconsMap(group, imageGroup)
	for entities_count = 1, #group do
		local entity = group[entities_count]
		table.insert(Assets, Asset("IMAGE", "images/" .. imageGroup .. "/" .. entity .. ".tex"))
		table.insert(Assets, Asset("ATLAS", "images/" .. imageGroup .. "/" .. entity .. ".xml"))
		AddMinimapAtlas("images/" .. imageGroup .. "/" .. entity .. ".xml")
		AddPrefabPostInit(entity, function (inst) inst.entity:AddMiniMapEntity():SetIcon(inst.prefab .. ".tex") end)
	end
end

AddIconsMap(general, "general")

if GetModConfigData("Basic_Mobs") == "true" then
	AddIconsMap(basic_mobs, "mobs")
end

if GetModConfigData("More_Mobs") == "true" then
	AddIconsMap(more_mobs, "mobs")
end

if GetModConfigData("Giants") == "true" then
	AddIconsMap(giants, "mobs")
end

if GetModConfigData("Tools") == "true" then
	AddIconsMap(tools, "tools")
end

if GetModConfigData("Minerals") == "true" then
	AddIconsMap(minerals, "minerals")
end

if GetModConfigData("Bones") == "true" then
	AddIconsMap(bones, "bones")
end

if GetModConfigData("Chester_Packim_Bones") == "true" then
	AddIconsMap(chester_packim_bones, "chester_packim_bones")
end

if GetModConfigData("Holes") == "true" then
	AddIconsMap(holes, "holes")
end

if GetModConfigData("Vegetation") == "true" then
	AddIconsMap(vegetation, "vegetation")
end

if GetModConfigData("Flowers") == "true" then
	AddIconsMap(flowers, "vegetation")
end

if GetModConfigData("Seashells") == "true" then
	AddIconsMap(seashells, "vegetation")
end

if GetModConfigData("Pigs_Rituals") == "true" then
	AddIconsMap(pigs_rituals, "pigs_rituals")
end

if GetModConfigData("Things") == "true" then
	AddIconsMap(things, "things")
end

if GetModConfigData("Walls") == "true" then
	AddIconsMap(walls, "walls")
end

if GetModConfigData("Tracks") == "true" then
	AddIconsMap(tracks, "tracks")
end