 local assets=
 {
	    Asset("ANIM", "anim/shadow_insanity2_basic.zip"),
 }
    


local prefabs =
{
   
}


local function NormalRetargetFn(inst)
    return FindEntity(inst, TUNING.SHADOWCREATURE_TARGET_DIST, function(guy)
            if not guy.LightWatcher or guy.LightWatcher:IsInLight() then
                return not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy) and not 
                (inst.components.follower and inst.components.follower.leader ~= nil and guy:HasTag("abigail"))
 and not guy:HasTag("player")
            end
        end,
        {"monster", "_health", "player"} -- see entityreplica.lua
        )
end

local function onkilledbyother(inst, attacker)
    if attacker and attacker.components.sanity then
        attacker.components.sanity:DoDelta(inst.sanityreward or TUNING.SANITY_SMALL)
    end
end

SetSharedLootTable( 'nightmare_creature',
{
    
})

local function NotifyBrainOfTarget(inst, target)
    if inst.brain and inst.brain.SetTarget then
        inst.brain:SetTarget(target)
    end
end



local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 30, function(dude) return dude:HasTag("shadowcreature") and not dude.components.health:IsDead() end, 1)
end

function IfDead(inst, data) print("terrorbeakpet dead")
inst.components.follower.leader:DoTaskInTime(20, function(player) player.SpawnTerrorbeakpet(player) end)

end




local function OnNewCombatTarget(inst, data)
    NotifyBrainOfTarget(inst, data.target)
end



   local function fn()
   
   local sounds =
    {
        attack = "dontstarve/sanity/creature2/attack",
        attack_grunt = "dontstarve/sanity/creature2/attack_grunt",
        death = "dontstarve/sanity/creature2/die",
        idle = "dontstarve/sanity/creature2/idle",
        taunt = "dontstarve/sanity/creature2/taunt",
        appear = "dontstarve/sanity/creature2/appear",
        disappear = "dontstarve/sanity/creature2/dissappear",
    }
    
	local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local physics = inst.entity:AddPhysics()
    local sound = inst.entity:AddSoundEmitter()
     
    inst.Transform:SetFourFaced()
     
    inst.AnimState:SetBank("shadowcreature2")
    inst.AnimState:SetBuild("shadow_insanity2_basic")
    anim:PlayAnimation("idle_loop")
    anim:SetMultColour(1, 1, 1, 0.5)
     
    MakeCharacterPhysics(inst, 10, 1.5)
    
    inst.Physics:SetCollisionGroup(COLLISION.SANITY)
    inst.Physics:CollidesWith(COLLISION.SANITY)
 
    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = (8)
    inst.sounds = sounds
    inst:SetStateGraph("SGshadowcreature")

    inst:AddTag("monster")
	    
        
		

        local brain = require "brains/nightmarepetbrain"
        inst:SetBrain(brain)
        
	    
        inst:AddComponent("health")
        inst.components.health:SetMaxHealth(300)
		
        inst:AddComponent("combat")
        inst.components.combat:SetDefaultDamage(40)
        inst.components.combat:SetAttackPeriod(TUNING.TERRORBEAK_ATTACK_PERIOD)
        inst.components.combat:SetRetargetFunction(3, NormalRetargetFn)
		
		inst:AddComponent("lootdropper")
        inst.components.lootdropper:SetChanceLootTable('shadow_creature')
		
		inst:AddComponent("follower")

        inst:ListenForEvent("attacked", OnAttacked)
		inst:ListenForEvent("newcombattarget", OnNewCombatTarget)
		
		inst:ListenForEvent("death", IfDead)
        -- if GetNightmareClock() then
        --     inst:ListenForEvent( "phasechange", 
        --                         function (source,data)
        --                             dprint("phase:",data.newphase)
        --                             if data.newphase == "dawn" then
        --                                 local dawntime = GetNightmareClock():GetDawnTime()
        --                                 inst:DoTaskInTime(GetRandomWithVariance(dawntime/2,dawntime/3),
        --                                                     function()
        --                                                         -- otherwise we end up with a lot of piles of nightmareful
        --                                                         inst.components.lootdropper:SetLoot({})
        --                                                         inst.sg:GoToState("disappear")
        --                                                     end)
        --                             end
        --                         end,
        --                         TheWorld)

        -- end

        inst:AddComponent("knownlocations") 

inst.persists=false
		
inst:ListenForEvent("stopfollowing", 
 function(inst) print("stopsfollowing")
 if not inst.components.health:IsDead() then inst.components.health:Kill() print("dies") print(inst.components.health.currenthealth) 
 end 
 end
 )
		
        return inst
    end




return Prefab("terrorbeakpet", fn, assets, prefabs)