local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/nightmareplayer.zip" ),
		
        
}
local prefabs = {}
local start_inv = {
	
	"nightmarefuel",
	"nightmarefuel",

}

	local function updatestats(inst)
	if GetClock():IsDay() then
	 inst.Light:Enable(true)
        inst.Light:SetRadius(15)
        inst.Light:SetFalloff(0.9)
        inst.Light:SetIntensity(0.6)
        inst.Light:SetColour(180/255,195/255,150/255)
		inst.Lighton = true
	elseif GetClock():IsDusk() then
	 inst.Light:Enable(true)
        inst.Light:SetRadius(15)
        inst.Light:SetFalloff(0.9)
        inst.Light:SetIntensity(0.6)
        inst.Light:SetColour(180/255,195/255,150/255)
		inst.Lighton = true
	elseif GetClock():IsNight() then
	 inst.Light:Enable(true)
        inst.Light:SetRadius(15)
        inst.Light:SetFalloff(0.9)
        inst.Light:SetIntensity(0.6)
        inst.Light:SetColour(180/255,195/255,150/255)
		inst.Lighton = true
	end
end

local function SpawnTerrorbeakpet(player)
    local pos = Vector3(player.Transform:GetWorldPosition())
    local offset = (FindWalkableOffset(pos,math.random()*PI*2,0.5,false))
    if offset == nil then
          if  player.components.talker then
          player.components.talker:Say("No Space!", 2.5)
          end
          return
    end
    pos=pos+offset
    local unit = SpawnPrefab("terrorbeakpet")
    unit.Transform:SetPosition (pos:Get())


unit:AddComponent("follower")
player.components.leader:AddFollower(unit) 
unit.spawnedforplayer=player
local brain = require("brains/nightmarepetbrain")
 unit:SetBrain(brain)
end

local fn = function(inst)
	local light = inst.entity:AddLight()
   -- choose which sounds this character will play
	inst.soundsname = "maxwell"
	
	inst.MiniMapEntity:SetIcon( "nightmareplayer.tex" )
	
	-- Stats	
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
    inst.components.combat.damagemultiplier = 1
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 7
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(170)
	inst.components.sanity:SetMax(200)
	inst.components.eater.strongstomach = true
	
	
    inst.SpawnTerrorbeakpet = SpawnTerrorbeakpet
	
	
	inst:AddTag("monster")
	
	inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
  	inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
  	inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
  	updatestats(inst)
	

	
inst:DoTaskInTime(0, function(inst) SpawnTerrorbeakpet(inst) end)


 inst.components.sanity.custom_rate_fn=
function(inst)
    local dapperness = 0
    local fireval = inst.LightWatcher:GetLightValue()
    
    local day = GetClock():IsDay() and not GetWorld():HasTag("cave")

       if day then
        dapperness = TUNING.SANITY_NIGHT_DARK * 0.2
       else

        local highval = TUNING.SANITY_HIGH_LIGHT
        local lowval = TUNING.SANITY_LOW_LIGHT

        if fireval > highval then
            dapperness =  TUNING.SANITY_NIGHT_LIGHT
        elseif fireval < lowval then
            dapperness = TUNING.SANITY_NIGHT_DARK
        else
            dapperness = TUNING.SANITY_NIGHT_MID
        end

         dapperness = dapperness*inst.components.sanity.night_drain_mult
 
dapperness= -2 * dapperness * ((GetClock():IsNight() and 2) or 1.7)

 end
return dapperness
end

   
end



 




return MakePlayerCharacter("nightmareplayer", prefabs, assets, fn, start_inv)

  


