require "behaviours/chaseandattack"
require "behaviours/minperiod"
require "behaviours/follow"

local MIN_FOLLOW = 4
local MAX_FOLLOW = 11
local MED_FOLLOW = 6
local MAX_WANDER_DIST = 10
local MAX_CHASE_TIME = 6

local nightmarepetBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end

function nightmarepetBrain:OnStart()
    
    local root = PriorityNode(
    {
        ChaseAndAttack(self.inst, 40),
		Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW, MED_FOLLOW, MAX_FOLLOW, true),       
		Wander(self.inst, function() if self.mytarget then return Point(self.mytarget.Transform:GetWorldPosition()) end end, MAX_WANDER_DIST)
    }, .25)
    
    self.bt = BT(self.inst, root)
end

return nightmarepetBrain