PrefabFiles = {
	"robecharacter",
	"robewand",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/robecharacter.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/robecharacter.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/robecharacter.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/robecharacter.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/robecharacter_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/robecharacter_silho.xml" ),

    Asset( "IMAGE", "bigportraits/robecharacter.tex" ),
    Asset( "ATLAS", "bigportraits/robecharacter.xml" ),
	
	Asset( "IMAGE", "images/map_icons/robecharacter.tex" ),
	Asset( "ATLAS", "images/map_icons/robecharacter.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

STRINGS.CHARACTER_TITLES.robecharacter = "The Paintress Witch"
STRINGS.CHARACTER_NAMES.robecharacter = "Robe"
STRINGS.CHARACTER_DESCRIPTIONS.robecharacter = "*Has a magic wand\n*TBD\n*Fast but weak, frail, and burns energy quickly"
STRINGS.CHARACTER_QUOTES.robecharacter = "\"I'm just trying to fix the colors creation forgot.\""

STRINGS.CHARACTERS.ROBECHARACTER = require "speech_robecharacter"

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "robecharacter")

AddMinimapAtlas("images/map_icons/robecharacter.xml")
AddModCharacter("robecharacter")

STRINGS.NAMES.ROBEWAND = "Chroma"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ROBEWAND = "It looks like some sort of paintbrush."

--This sections controls the cheaper crafting aspect of the character
--prefab name of your character
local CHARACTER_PREFAB = "robecharacter"
--need 10% of original ingredients, rounded to integer
local INGREDIENT_MODIFIER = 0.75
--tab name(s)
local RECIPE_TAB = {
    "MAGIC"
}

local ISDST = GLOBAL.TheSim:GetGameID() == "DST"
local Text = GLOBAL.require("widgets/text")
local Image = GLOBAL.require("widgets/image")
local function Round(num)
    return ISDST and GLOBAL.RoundBiasedUp(num) or GLOBAL.RoundUp(num)
end

AddComponentPostInit("builder",function(inst)
    if not inst.GetIngredients then
        inst.RemoveIngredients=function(self, recname)
            local recipe = GLOBAL.GetRecipe(recname)
            self.inst:PushEvent("consumeingredients", {recipe = recipe})
            if recipe then
                local modifier = (self.inst.prefab == CHARACTER_PREFAB and table.contains(RECIPE_TAB, recipe.tab.str)) and INGREDIENT_MODIFIER or 1
                modifier = math.min(modifier, self.ingredientmod)
                for k, v in pairs(recipe.ingredients) do
                    local amt = math.max(1, GLOBAL.RoundUp(v.amount * modifier))
                    self.inst.components.inventory:ConsumeByName(v.type, amt)
                end
            end
        end
    else
        inst.GetIngredients=function(self, recname)
            local recipe = ISDST and GLOBAL.AllRecipes[recname] or GLOBAL.GetRecipe(recname)
            if recipe then
                local ingredients = {}
                local modifier = (self.inst.prefab == CHARACTER_PREFAB and table.contains(RECIPE_TAB, recipe.tab.str)) and INGREDIENT_MODIFIER or 1
                modifier = math.min(modifier, self.ingredientmod)
                for k,v in pairs(recipe.ingredients) do
                    local amt = math.max(1, Round(v.amount * modifier))
                    local items = self.inst.components.inventory:GetItemByName(v.type, amt)
                    ingredients[v.type] = items
                end
                return ingredients
            end
        end
    end
    inst.CanBuild=function(self, recname)
        local recipe = ISDST and GLOBAL.GetValidRecipe(recname) or GLOBAL.GetRecipe(recname)
        if recipe == nil then
            return false
        elseif not self.freebuildmode then
            local modifier = (self.inst.prefab == CHARACTER_PREFAB and table.contains(RECIPE_TAB, recipe.tab.str)) and INGREDIENT_MODIFIER or 1
            modifier = math.min(modifier, self.ingredientmod)
            for i, v in ipairs(recipe.ingredients) do
                if not self.inst.components.inventory:Has(v.type, math.max(1, Round(v.amount * modifier))) then
                    return false
                end
            end
        end
        if ISDST then
            for i, v in ipairs(recipe.character_ingredients) do
                if not self:HasCharacterIngredient(v) then
                    return false
                end
            end
            for i, v in ipairs(recipe.tech_ingredients) do
                if not self:HasTechIngredient(v) then
                    return false
                end
            end
        end
        return true
    end
end)

if ISDST then
    AddClassPostConstruct("components/builder_replica",function(inst)
        inst.CanBuild=function(self, recipename)
            if self.inst.components.builder ~= nil then
                return self.inst.components.builder:CanBuild(recipename)
            elseif self.classified ~= nil then
                local recipe = GLOBAL.GetValidRecipe(recipename)
                if recipe == nil then
                    return false
                elseif not self.classified.isfreebuildmode:value() then
                    local modifier = (self.inst.prefab == CHARACTER_PREFAB and GLOBAL.table.contains(RECIPE_TAB, recipe.tab.str)) and INGREDIENT_MODIFIER or 1
                    modifier = math.min(modifier, self:IngredientMod())
                    for i, v in ipairs(recipe.ingredients) do
                        if not self.inst.replica.inventory:Has(v.type, math.max(1, GLOBAL.RoundBiasedUp(v.amount * modifier))) then
                            return false
                        end
                    end
                end
                for i, v in ipairs(recipe.character_ingredients) do
                    if not self:HasCharacterIngredient(v) then
                        return false
                    end
                end
                for i, v in ipairs(recipe.tech_ingredients) do
                    if not self:HasTechIngredient(v) then
                        return false
                    end
                end
                return true
            else
                return false
            end
        end
    end)
end

AddClassPostConstruct("widgets/recipepopup",function(inst)
    local oldRefresh=inst.Refresh
    inst.Refresh=function(self)
        oldRefresh(self)
        if self.owner == nil then
            return false
        end
        local ingredientmod = ISDST and self.owner.replica.builder:IngredientMod() or self.owner.components.builder.ingredientmod
        local inventory = ISDST and self.owner.replica.inventory or self.owner.components.inventory
        if self.owner.prefab == CHARACTER_PREFAB and GLOBAL.table.contains(RECIPE_TAB, self.recipe.tab.str) and ingredientmod > INGREDIENT_MODIFIER then
            local skip = ISDST and #self.recipe.tech_ingredients or 0
            for i,v in ipairs(self.recipe.ingredients) do
                local quantity = math.max(1,Round(v.amount * INGREDIENT_MODIFIER))
                local has, num_found = inventory:Has(v.type, quantity)
                local hud_atlas = GLOBAL.resolvefilepath("images/hud.xml")
                self.ing[i+skip]:RemoveChild(self.ing[i+skip].bg)
                self.ing[i+skip].bg:Kill()
                self.ing[i+skip]:RemoveChild(self.ing[i+skip].ing)
                self.ing[i+skip].ing:Kill()
                self.ing[i+skip]:RemoveChild(self.ing[i+skip].quant)
                self.ing[i+skip].quant:Kill()
                self.ing[i+skip].bg = self.ing[i+skip]:AddChild(Image(hud_atlas, has and "inv_slot.tex" or "resource_needed.tex"))
                local item_img = (not ISDST and GLOBAL.SaveGameIndex:IsModeShipwrecked() and GLOBAL.SW_ICONS[v.type] ~= nil) and GLOBAL.SW_ICONS[v.type] or v.type
                self.ing[i+skip].ing = self.ing[i+skip]:AddChild(Image(v.atlas, v.type..".tex"))
                self.ing[i+skip].quant = self.ing[i+skip]:AddChild(Text(GLOBAL.SMALLNUMBERFONT, GLOBAL.JapaneseOnPS4() and 30 or 24))
                self.ing[i+skip].quant:SetPosition(7, -32, 0)
                self.ing[i+skip].quant:SetString(string.format("%d/%d", num_found, quantity))
                if not has then
                    self.ing[i+skip].quant:SetColour(1, 155/255, 155/255, 1)
                end
            end
        end
    end
end)
