SELECT
     T.TABNAME AS TABLENAME, 
     PK.COLNAME,
     PK.TYPENAME,
     CASE WHEN PK.TYPENAME in (''VARCHAR'', ''CHARACTER'', ''DECIMAL'') THEN PK.LENGTH ELSE 0 END AS LENGTH,
     PK.SCALE,
     PK.KEYSEQ
FROM syscat.TABLES T JOIN syscat.COLUMNS PK ON T.TABNAME=PK.TABNAME AND PK.TABSCHEMA=T.TABSCHEMA
WHERE T.TABSCHEMA=UPPER(''{0}'') AND T.TYPE=''T'' AND PK.KEYSEQ IS NOT NULL AND PK.KEYSEQ>0
ORDER BY TABLENAME
