/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.Arrays;

public class MathLib {
    public static final double TWO_PI = Math.PI * 2;
    public static final double LOG10 = Math.log(10.0);
    public static final double LOG2 = Math.log(2.0);

    private MathLib() {
    }

    public static double log2(double x) {
        return Math.log(x) / LOG2;
    }

    public static double log10(double x) {
        return Math.log(x) / LOG10;
    }

    public static double safeLog10(double x) {
        boolean neg;
        boolean bl = neg = x < 0.0;
        if (neg) {
            x = -x;
        }
        if (x < 10.0) {
            x += (10.0 - x) / 10.0;
        }
        x = Math.log(x) / LOG10;
        return neg ? -x : x;
    }

    public static double safeSqrt(double x) {
        return x < 0.0 ? -Math.sqrt(-x) : Math.sqrt(x);
    }

    public static double interp(int scale, double val, double[] dist) {
        switch (scale) {
            case 0: {
                return MathLib.linearInterp(val, dist[0], dist[dist.length - 1]);
            }
            case 1: {
                return MathLib.logInterp(val, dist[0], dist[dist.length - 1]);
            }
            case 2: {
                return MathLib.sqrtInterp(val, dist[0], dist[dist.length - 1]);
            }
            case 3: {
                return MathLib.quantile(val, dist);
            }
        }
        throw new IllegalArgumentException("Unrecognized scale value: " + scale);
    }

    public static double linearInterp(double val, double min, double max) {
        double denominator = max - min;
        if (denominator == 0.0) {
            return 0.0;
        }
        return (val - min) / denominator;
    }

    public static double logInterp(double val, double min, double max) {
        double logMin = MathLib.safeLog10(min);
        double denominator = MathLib.safeLog10(max) - logMin;
        if (denominator == 0.0) {
            return 0.0;
        }
        return (MathLib.safeLog10(val) - logMin) / denominator;
    }

    public static double sqrtInterp(double val, double min, double max) {
        double sqrtMin = MathLib.safeSqrt(min);
        double denominator = MathLib.safeSqrt(max) - sqrtMin;
        if (denominator == 0.0) {
            return 0.0;
        }
        return (MathLib.safeSqrt(val) - sqrtMin) / denominator;
    }

    public static double[] quantiles(int n, double[] values) {
        values = (double[])values.clone();
        Arrays.sort(values);
        double[] qtls = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            qtls[i] = values[(values.length - 1) * i / n];
        }
        return qtls;
    }

    public static double quantile(double val, double[] quantiles) {
        int x1 = 1;
        int x2 = quantiles.length;
        int i = x2 / 2;
        while (x1 < x2 && quantiles[i] != val) {
            if (quantiles[i] < val) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return (double)i / (double)(quantiles.length - 1);
    }
}

