/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.Iterator;
import java.util.logging.Logger;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.tuple.TableTuple;
import prefuse.util.StringLib;
import prefuse.util.collections.IntIterator;

public class TupleManager {
    protected Graph m_graph;
    protected Table m_table;
    protected Class m_tupleType;
    private TableTuple[] m_tuples;

    public TupleManager(Table t, Graph g, Class tupleType) {
        this.init(t, g, tupleType);
    }

    public void init(Table t, Graph g, Class tupleType) {
        if (this.m_table != null) {
            throw new IllegalStateException("This TupleManager has already been initialized");
        }
        this.m_table = t;
        this.m_graph = g;
        this.m_tupleType = tupleType;
        this.m_tuples = null;
    }

    public Class getTupleType() {
        return this.m_tupleType;
    }

    private void ensureTupleArray(int row) {
        int nrows = Math.max(this.m_table.getRowCount(), row + 1);
        if (this.m_tuples == null) {
            this.m_tuples = new TableTuple[nrows];
        } else if (this.m_tuples.length < nrows) {
            int capacity = Math.max(3 * this.m_tuples.length / 2 + 1, nrows);
            TableTuple[] tuples = new TableTuple[capacity];
            System.arraycopy(this.m_tuples, 0, tuples, 0, this.m_tuples.length);
            this.m_tuples = tuples;
        }
    }

    public Tuple getTuple(int row) {
        if (this.m_table.isValidRow(row)) {
            this.ensureTupleArray(row);
            if (this.m_tuples[row] == null) {
                this.m_tuples[row] = this.newTuple(row);
                return this.m_tuples[row];
            }
            return this.m_tuples[row];
        }
        throw new IllegalArgumentException("Invalid row index: " + row);
    }

    protected TableTuple newTuple(int row) {
        try {
            TableTuple t = (TableTuple)this.m_tupleType.newInstance();
            t.init(this.m_table, this.m_graph, row);
            return t;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).warning(e.getMessage() + "\n" + StringLib.getStackTrace(e));
            return null;
        }
    }

    public void invalidate(int row) {
        if (this.m_tuples == null || row < 0 || row >= this.m_tuples.length) {
            return;
        }
        if (this.m_tuples[row] != null) {
            this.m_tuples[row].invalidate();
            this.m_tuples[row] = null;
        }
    }

    public void invalidateAll() {
        if (this.m_tuples == null) {
            return;
        }
        for (int i = 0; i < this.m_tuples.length; ++i) {
            this.invalidate(i);
        }
    }

    public Iterator iterator(IntIterator rows) {
        return new TupleManagerIterator(this, rows);
    }

    public class TupleManagerIterator
    implements Iterator {
        private TupleManager m_tuples;
        private IntIterator m_rows;

        public TupleManagerIterator(TupleManager tuples, IntIterator rows) {
            this.m_tuples = tuples;
            this.m_rows = rows;
        }

        public boolean hasNext() {
            return this.m_rows.hasNext();
        }

        public Object next() {
            return this.m_tuples.getTuple(this.m_rows.nextInt());
        }

        public void remove() {
            this.m_rows.remove();
        }
    }
}

