/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import prefuse.data.Table;
import prefuse.data.column.ColumnMetadata;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.ComparisonPredicate;
import prefuse.data.expression.Literal;
import prefuse.data.expression.OrPredicate;
import prefuse.data.expression.Predicate;
import prefuse.data.query.DynamicQueryBinding;
import prefuse.data.query.ListModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.ui.JToggleGroup;

public class ListQueryBinding
extends DynamicQueryBinding {
    private static final String ALL = "All";
    private Class m_type;
    private ListModel m_model;
    private Listener m_lstnr;
    private boolean m_includeAll;

    public ListQueryBinding(TupleSet ts, String field) {
        this(ts, field, true);
    }

    public ListQueryBinding(TupleSet ts, String field, boolean includeAllOption) {
        super(ts, field);
        this.m_type = DataLib.inferType(ts, field);
        this.m_lstnr = new Listener();
        this.m_includeAll = includeAllOption;
        this.initPredicate();
        this.initModel();
    }

    private void initPredicate() {
        OrPredicate orP = new OrPredicate();
        orP.add(BooleanLiteral.TRUE);
        this.setPredicate(orP);
    }

    private void initModel() {
        if (this.m_model != null) {
            this.m_model.removeListSelectionListener(this.m_lstnr);
        }
        Object[] o = null;
        if (this.m_tuples instanceof Table) {
            ColumnMetadata md = ((Table)this.m_tuples).getMetadata(this.m_field);
            o = md.getOrdinalArray();
        } else {
            o = DataLib.ordinalArray(this.m_tuples.tuples(), this.m_field);
        }
        this.m_model = new ListModel(o);
        this.m_model.addListSelectionListener(this.m_lstnr);
        if (this.m_includeAll) {
            this.m_model.insertElementAt(ALL, 0);
            this.m_model.setSelectedItem(ALL);
        }
    }

    public ListModel getListModel() {
        return this.m_model;
    }

    public JComponent createComponent() {
        return this.createCheckboxGroup();
    }

    public JList createList() {
        JList list = new JList(this.m_model);
        list.setSelectionModel(this.m_model);
        return list;
    }

    public JComboBox createComboBox() {
        return new JComboBox(this.m_model);
    }

    public JToggleGroup createCheckboxGroup() {
        return this.createToggleGroup(0);
    }

    public JToggleGroup createRadioGroup() {
        return this.createToggleGroup(1);
    }

    private JToggleGroup createToggleGroup(int type) {
        return new JToggleGroup(type, this.m_model, this.m_model);
    }

    private ComparisonPredicate getComparison(Object o) {
        ColumnExpression left = new ColumnExpression(this.m_field);
        Literal right = Literal.getLiteral(o, this.m_type);
        return new ComparisonPredicate(2, left, right);
    }

    private class Listener
    implements ListSelectionListener {
        private Listener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListModel model = (ListModel)e.getSource();
            OrPredicate orP = (OrPredicate)ListQueryBinding.this.m_query;
            if (model.isSelectionEmpty()) {
                orP.clear();
            } else if (ListQueryBinding.this.m_includeAll && model.isSelectedIndex(0)) {
                orP.set(BooleanLiteral.TRUE);
            } else {
                int min = model.getMinSelectionIndex();
                int max = model.getMaxSelectionIndex();
                int count = 0;
                for (int i = min; i <= max; ++i) {
                    if (!model.isSelectedIndex(i)) continue;
                    ++count;
                }
                if (count == model.getSize()) {
                    orP.set(BooleanLiteral.TRUE);
                } else if (count == 1) {
                    orP.set(ListQueryBinding.this.getComparison(model.getElementAt(min)));
                } else {
                    Predicate[] p = new Predicate[count];
                    int j = 0;
                    for (int i = min; i <= max; ++i) {
                        if (!model.isSelectedIndex(i)) continue;
                        p[j++] = ListQueryBinding.this.getComparison(model.getElementAt(i));
                    }
                    orP.set(p);
                }
            }
        }
    }
}

