/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.util.Arrays;
import prefuse.data.parser.BooleanParser;
import prefuse.data.parser.ColorIntParser;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.DateParser;
import prefuse.data.parser.DateTimeParser;
import prefuse.data.parser.DoubleArrayParser;
import prefuse.data.parser.DoubleParser;
import prefuse.data.parser.FloatArrayParser;
import prefuse.data.parser.FloatParser;
import prefuse.data.parser.IntArrayParser;
import prefuse.data.parser.IntParser;
import prefuse.data.parser.LongArrayParser;
import prefuse.data.parser.LongParser;
import prefuse.data.parser.StringParser;
import prefuse.data.parser.TimeParser;

public class ParserFactory
implements Cloneable {
    private static final DataParser[] DEFAULT_PARSERS = new DataParser[]{new IntParser(), new LongParser(), new DoubleParser(), new FloatParser(), new BooleanParser(), new ColorIntParser(), new DateParser(), new TimeParser(), new DateTimeParser(), new IntArrayParser(), new LongArrayParser(), new FloatArrayParser(), new DoubleArrayParser(), new StringParser()};
    private static ParserFactory DEFAULT_FACTORY = new ParserFactory(DEFAULT_PARSERS);
    private DataParser[] m_parsers;
    private boolean[] m_isCandidate;

    public static ParserFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public static void setDefaultFactory(ParserFactory factory) {
        DEFAULT_FACTORY = factory;
    }

    public ParserFactory() {
        this(DEFAULT_PARSERS);
    }

    public Object clone() {
        return new ParserFactory(this.m_parsers);
    }

    public ParserFactory(DataParser[] parsers) {
        for (int i = 0; i < parsers.length; ++i) {
            if (parsers[i] != null) continue;
            throw new IllegalArgumentException("Input parsers must be non-null");
        }
        this.m_parsers = parsers;
        this.m_isCandidate = new boolean[this.m_parsers.length];
        this.reset();
    }

    protected void reset() {
        Arrays.fill(this.m_isCandidate, true);
    }

    protected void sample(String val) {
        for (int i = 0; i < this.m_parsers.length; ++i) {
            if (!this.m_isCandidate[i]) continue;
            this.m_isCandidate[i] = this.m_parsers[i].canParse(val);
        }
    }

    protected DataParser getParser() {
        for (int i = 0; i < this.m_parsers.length; ++i) {
            if (!this.m_isCandidate[i]) continue;
            return this.m_parsers[i];
        }
        return null;
    }

    public DataParser getParser(Class type) {
        for (int i = 0; i < this.m_parsers.length; ++i) {
            if (!this.m_parsers[i].getType().equals(type)) continue;
            return this.m_parsers[i];
        }
        return null;
    }

    public DataParser getParser(String[] data, int startRow) {
        return this.getParser(new String[][]{data}, 0, startRow);
    }

    public DataParser getParser(String[][] data, int col, int startRow) {
        if (data == null || data.length == 0) {
            return null;
        }
        int nrows = data.length;
        this.reset();
        for (int row = startRow; row < nrows; ++row) {
            this.sample(data[row][col]);
        }
        DataParser parser = this.getParser();
        return parser;
    }
}

