/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import prefuse.Display;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ArrayLib;
import prefuse.visual.NodeItem;

public class NodeLinkTreeLayout
extends TreeLayout {
    private int m_orientation;
    private double m_bspace = 5.0;
    private double m_tspace = 25.0;
    private double m_dspace = 50.0;
    private double m_offset = 50.0;
    private double[] m_depths = new double[10];
    private int m_maxDepth = 0;
    private double m_ax;
    private double m_ay;
    public static final String PARAMS = "_reingoldTilfordParams";
    public static final Schema PARAMS_SCHEMA = new Schema();

    public NodeLinkTreeLayout(String group) {
        super(group);
        this.m_orientation = 0;
    }

    public NodeLinkTreeLayout(String group, int orientation, double dspace, double bspace, double tspace) {
        super(group);
        this.m_orientation = orientation;
        this.m_dspace = dspace;
        this.m_bspace = bspace;
        this.m_tspace = tspace;
    }

    public void setOrientation(int orientation) {
        if (orientation < 0 || orientation >= 5 || orientation == 4) {
            throw new IllegalArgumentException("Unsupported orientation value: " + orientation);
        }
        this.m_orientation = orientation;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setDepthSpacing(double d) {
        this.m_dspace = d;
    }

    public double getDepthSpacing() {
        return this.m_dspace;
    }

    public void setBreadthSpacing(double b) {
        this.m_bspace = b;
    }

    public double getBreadthSpacing() {
        return this.m_bspace;
    }

    public void setSubtreeSpacing(double s) {
        this.m_tspace = s;
    }

    public double getSubtreeSpacing() {
        return this.m_tspace;
    }

    public void setRootNodeOffset(double o) {
        this.m_offset = o;
    }

    public double getRootNodeOffset() {
        return this.m_offset;
    }

    public Point2D getLayoutAnchor() {
        if (this.m_anchor != null) {
            return this.m_anchor;
        }
        this.m_tmpa.setLocation(0.0, 0.0);
        if (this.m_vis != null) {
            Display d = this.m_vis.getDisplay(0);
            Rectangle2D b = this.getLayoutBounds();
            switch (this.m_orientation) {
                case 0: {
                    this.m_tmpa.setLocation(this.m_offset, (double)d.getHeight() / 2.0);
                    break;
                }
                case 1: {
                    this.m_tmpa.setLocation(b.getMaxX() - this.m_offset, (double)d.getHeight() / 2.0);
                    break;
                }
                case 2: {
                    this.m_tmpa.setLocation((double)d.getWidth() / 2.0, this.m_offset);
                    break;
                }
                case 3: {
                    this.m_tmpa.setLocation((double)d.getWidth() / 2.0, b.getMaxY() - this.m_offset);
                }
            }
            d.getInverseTransform().transform(this.m_tmpa, this.m_tmpa);
        }
        return this.m_tmpa;
    }

    private double spacing(NodeItem l, NodeItem r, boolean siblings) {
        boolean w = this.m_orientation == 2 || this.m_orientation == 3;
        return (siblings ? this.m_bspace : this.m_tspace) + 0.5 * (w ? l.getBounds().getWidth() + r.getBounds().getWidth() : l.getBounds().getHeight() + r.getBounds().getHeight());
    }

    private void updateDepths(int depth, NodeItem item) {
        double d;
        boolean v = this.m_orientation == 2 || this.m_orientation == 3;
        double d2 = d = v ? item.getBounds().getHeight() : item.getBounds().getWidth();
        if (this.m_depths.length <= depth) {
            this.m_depths = ArrayLib.resize(this.m_depths, 3 * depth / 2);
        }
        this.m_depths[depth] = Math.max(this.m_depths[depth], d);
        this.m_maxDepth = Math.max(this.m_maxDepth, depth);
    }

    private void determineDepths() {
        for (int i = 1; i < this.m_maxDepth; ++i) {
            int n = i;
            this.m_depths[n] = this.m_depths[n] + (this.m_depths[i - 1] + this.m_dspace);
        }
    }

    public void run(double frac) {
        Graph g = (Graph)this.m_vis.getGroup(this.m_group);
        this.initSchema(g.getNodes());
        Arrays.fill(this.m_depths, 0.0);
        this.m_maxDepth = 0;
        Point2D a = this.getLayoutAnchor();
        this.m_ax = a.getX();
        this.m_ay = a.getY();
        NodeItem root = this.getLayoutRoot();
        Params rp = this.getParams(root);
        this.firstWalk(root, 0, 1);
        this.determineDepths();
        this.secondWalk(root, null, -rp.prelim, 0);
    }

    private void firstWalk(NodeItem n, int num, int depth) {
        Params np = this.getParams(n);
        np.number = num;
        this.updateDepths(depth, n);
        boolean expanded = n.isExpanded();
        if (n.getChildCount() == 0 || !expanded) {
            NodeItem l = (NodeItem)n.getPreviousSibling();
            np.prelim = l == null ? 0.0 : this.getParams((NodeItem)l).prelim + this.spacing(l, n, true);
        } else if (expanded) {
            NodeItem leftMost = (NodeItem)n.getFirstChild();
            NodeItem rightMost = (NodeItem)n.getLastChild();
            NodeItem defaultAncestor = leftMost;
            int i = 0;
            for (NodeItem c = leftMost; c != null; c = (NodeItem)c.getNextSibling()) {
                this.firstWalk(c, i, depth + 1);
                defaultAncestor = this.apportion(c, defaultAncestor);
                ++i;
            }
            this.executeShifts(n);
            double midpoint = 0.5 * (this.getParams((NodeItem)leftMost).prelim + this.getParams((NodeItem)rightMost).prelim);
            NodeItem left = (NodeItem)n.getPreviousSibling();
            if (left != null) {
                np.prelim = this.getParams((NodeItem)left).prelim + this.spacing(left, n, true);
                np.mod = np.prelim - midpoint;
            } else {
                np.prelim = midpoint;
            }
        }
    }

    private NodeItem apportion(NodeItem v, NodeItem a) {
        NodeItem w = (NodeItem)v.getPreviousSibling();
        if (w != null) {
            NodeItem vop;
            NodeItem vip = vop = v;
            NodeItem vim = w;
            NodeItem vom = (NodeItem)vip.getParent().getFirstChild();
            double sip = this.getParams((NodeItem)vip).mod;
            double sop = this.getParams((NodeItem)vop).mod;
            double sim = this.getParams((NodeItem)vim).mod;
            double som = this.getParams((NodeItem)vom).mod;
            NodeItem nr = this.nextRight(vim);
            NodeItem nl = this.nextLeft(vip);
            while (nr != null && nl != null) {
                vim = nr;
                vip = nl;
                vom = this.nextLeft(vom);
                vop = this.nextRight(vop);
                this.getParams((NodeItem)vop).ancestor = v;
                double shift = this.getParams((NodeItem)vim).prelim + sim - (this.getParams((NodeItem)vip).prelim + sip) + this.spacing(vim, vip, false);
                if (shift > 0.0) {
                    this.moveSubtree(this.ancestor(vim, v, a), v, shift);
                    sip += shift;
                    sop += shift;
                }
                sim += this.getParams((NodeItem)vim).mod;
                sip += this.getParams((NodeItem)vip).mod;
                som += this.getParams((NodeItem)vom).mod;
                sop += this.getParams((NodeItem)vop).mod;
                nr = this.nextRight(vim);
                nl = this.nextLeft(vip);
            }
            if (nr != null && this.nextRight(vop) == null) {
                Params vopp = this.getParams(vop);
                vopp.thread = nr;
                vopp.mod += sim - sop;
            }
            if (nl != null && this.nextLeft(vom) == null) {
                Params vomp = this.getParams(vom);
                vomp.thread = nl;
                vomp.mod += sip - som;
                a = v;
            }
        }
        return a;
    }

    private NodeItem nextLeft(NodeItem n) {
        NodeItem c = null;
        if (n.isExpanded()) {
            c = (NodeItem)n.getFirstChild();
        }
        return c != null ? c : this.getParams((NodeItem)n).thread;
    }

    private NodeItem nextRight(NodeItem n) {
        NodeItem c = null;
        if (n.isExpanded()) {
            c = (NodeItem)n.getLastChild();
        }
        return c != null ? c : this.getParams((NodeItem)n).thread;
    }

    private void moveSubtree(NodeItem wm, NodeItem wp, double shift) {
        Params wmp = this.getParams(wm);
        Params wpp = this.getParams(wp);
        double subtrees = wpp.number - wmp.number;
        wpp.change -= shift / subtrees;
        wpp.shift += shift;
        wmp.change += shift / subtrees;
        wpp.prelim += shift;
        wpp.mod += shift;
    }

    private void executeShifts(NodeItem n) {
        double shift = 0.0;
        double change = 0.0;
        for (NodeItem c = (NodeItem)n.getLastChild(); c != null; c = (NodeItem)c.getPreviousSibling()) {
            Params cp = this.getParams(c);
            cp.prelim += shift;
            cp.mod += shift;
            shift += cp.shift + (change += cp.change);
        }
    }

    private NodeItem ancestor(NodeItem vim, NodeItem v, NodeItem a) {
        NodeItem p = (NodeItem)v.getParent();
        Params vimp = this.getParams(vim);
        if (vimp.ancestor.getParent() == p) {
            return vimp.ancestor;
        }
        return a;
    }

    private void secondWalk(NodeItem n, NodeItem p, double m, int depth) {
        Params np = this.getParams(n);
        this.setBreadth(n, p, np.prelim + m);
        this.setDepth(n, p, this.m_depths[depth]);
        if (n.isExpanded()) {
            ++depth;
            for (NodeItem c = (NodeItem)n.getFirstChild(); c != null; c = (NodeItem)c.getNextSibling()) {
                this.secondWalk(c, n, m + np.mod, depth);
            }
        }
        np.clear();
    }

    private void setBreadth(NodeItem n, NodeItem p, double b) {
        switch (this.m_orientation) {
            case 0: 
            case 1: {
                this.setY(n, p, this.m_ay + b);
                break;
            }
            case 2: 
            case 3: {
                this.setX(n, p, this.m_ax + b);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void setDepth(NodeItem n, NodeItem p, double d) {
        switch (this.m_orientation) {
            case 0: {
                this.setX(n, p, this.m_ax + d);
                break;
            }
            case 1: {
                this.setX(n, p, this.m_ax - d);
                break;
            }
            case 2: {
                this.setY(n, p, this.m_ay + d);
                break;
            }
            case 3: {
                this.setY(n, p, this.m_ay - d);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void initSchema(TupleSet ts) {
        ts.addColumns(PARAMS_SCHEMA);
    }

    private Params getParams(NodeItem item) {
        Params rp = (Params)item.get(PARAMS);
        if (rp == null) {
            rp = new Params();
            item.set(PARAMS, (Object)rp);
        }
        if (rp.number == -2) {
            rp.init(item);
        }
        return rp;
    }

    static {
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class);
    }

    public static class Params
    implements Cloneable {
        double prelim;
        double mod;
        double shift;
        double change;
        int number = -2;
        NodeItem ancestor = null;
        NodeItem thread = null;

        public void init(NodeItem item) {
            this.ancestor = item;
            this.number = -1;
        }

        public void clear() {
            this.number = -2;
            this.change = 0.0;
            this.shift = 0.0;
            this.mod = 0.0;
            this.prelim = 0.0;
            this.thread = null;
            this.ancestor = null;
        }
    }
}

