/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.logging.Logger;
import prefuse.action.layout.AxisLayout;
import prefuse.action.layout.Layout;
import prefuse.data.Schema;
import prefuse.data.query.ObjectRangeModel;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.Index;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;

public class AxisLabelLayout
extends Layout {
    public static final String FRAC = "frac";
    public static final String LABEL = "_label";
    public static final String VALUE = "_value";
    private AxisLayout m_layout;
    private ValuedRangeModel m_model;
    private double m_lo;
    private double m_hi;
    private double m_prevlo;
    private double m_prevhi;
    private NumberFormat m_nf = NumberFormat.getInstance();
    private int m_axis;
    private boolean m_asc = true;
    private int m_scale = 0;
    private double m_spacing;

    public AxisLabelLayout(String group, int axis, ValuedRangeModel values) {
        this(group, axis, values, null);
    }

    public AxisLabelLayout(String group, int axis, ValuedRangeModel values, Rectangle2D bounds) {
        super(group);
        if (bounds != null) {
            this.setLayoutBounds(bounds);
        }
        this.m_model = values;
        this.m_axis = axis;
        this.m_spacing = 50.0;
    }

    public AxisLabelLayout(String group, AxisLayout layout) {
        this(group, layout, null, 50.0);
    }

    public AxisLabelLayout(String group, AxisLayout layout, Rectangle2D bounds) {
        this(group, layout, bounds, 50.0);
    }

    public AxisLabelLayout(String group, AxisLayout layout, Rectangle2D bounds, double spacing) {
        super(group);
        if (bounds != null) {
            this.setLayoutBounds(bounds);
        }
        this.m_layout = layout;
        this.m_model = layout.getRangeModel();
        this.m_axis = layout.getAxis();
        this.m_scale = layout.getScale();
        this.m_spacing = spacing;
    }

    public NumberFormat getNumberFormat() {
        return this.m_nf;
    }

    public void setNumberFormat(NumberFormat nf) {
        this.m_nf = nf;
    }

    public double getSpacing() {
        return this.m_spacing;
    }

    public void setSpacing(double spacing) {
        this.m_spacing = spacing;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int scale) {
        if (scale < 0 || scale >= 4) {
            throw new IllegalArgumentException("Unrecognized scale type: " + scale);
        }
        this.m_scale = scale;
    }

    public boolean isAscending() {
        return this.m_asc;
    }

    public void setAscending(boolean asc) {
        this.m_asc = asc;
    }

    public void setRangeModel(ValuedRangeModel model) {
        this.m_model = model;
    }

    public void run(double frac) {
        if (this.m_model == null && this.m_layout != null) {
            this.m_model = this.m_layout.getRangeModel();
        }
        if (this.m_model == null) {
            Logger.getLogger(this.getClass().getName()).warning("Axis labels missing a range model.");
            return;
        }
        VisualTable labels = this.getTable();
        Double dfrac = (Double)labels.getClientProperty(FRAC);
        double fr = dfrac == null ? 1.0 : dfrac;
        this.m_prevlo += fr * (this.m_lo - this.m_prevlo);
        this.m_prevhi += fr * (this.m_hi - this.m_prevhi);
        if (this.m_model instanceof ObjectRangeModel) {
            this.m_lo = this.m_model.getValue();
            this.m_hi = this.m_lo + (double)this.m_model.getExtent();
            this.ordinalLayout(labels);
        } else {
            this.m_lo = ((Number)this.m_model.getLowValue()).doubleValue();
            this.m_hi = ((Number)this.m_model.getHighValue()).doubleValue();
            switch (this.m_scale) {
                case 1: {
                    this.logLayout(labels);
                    break;
                }
                case 2: {
                    this.sqrtLayout(labels);
                    break;
                }
                default: {
                    this.linearLayout(labels);
                }
            }
        }
        this.garbageCollect(labels);
    }

    protected void linearLayout(VisualTable labels) {
        Rectangle2D b = this.getLayoutBounds();
        double breadth = this.getBreadth(b);
        double span = this.m_hi - this.m_lo;
        double pspan = this.m_prevhi - this.m_prevlo;
        double vlo = 0.0;
        vlo = this.m_lo >= 0.0 ? Math.pow(10.0, Math.floor(MathLib.log10(this.m_lo))) : -Math.pow(10.0, 1.0 + Math.floor(MathLib.log10(-this.m_lo)));
        Iterator iter = labels.tuples();
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            this.reset(item);
            double v = item.getDouble(VALUE);
            double x = span == 0.0 ? 0.0 : (v - this.m_lo) / span * breadth;
            this.set(item, x, b);
        }
        Index index = labels.index(VALUE);
        double step = this.getLinearStep(span, span == 0.0 ? 0.0 : breadth / span);
        if (step == 0.0) {
            step = 1.0;
        }
        for (double v = vlo; v <= this.m_hi; v += step) {
            double f;
            VisualItem item;
            double x = (v - this.m_lo) / span * breadth;
            if (x < -0.5) continue;
            int r = index.get(v);
            if (r >= 0) {
                item = labels.getItem(r);
                item.setVisible(true);
                item.setEndVisible(true);
                continue;
            }
            item = labels.addItem();
            item.set(LABEL, (Object)this.m_nf.format(v));
            item.setDouble(VALUE, v);
            double d = f = pspan == 0.0 ? 0.0 : (v - this.m_prevlo) / pspan;
            if (f <= 0.0 || f >= 1.0) {
                item.setStartVisible(true);
            }
            this.set(item, f * breadth, b);
            this.set(item, x, b);
        }
    }

    protected void sqrtLayout(VisualTable labels) {
        Rectangle2D b = this.getLayoutBounds();
        double breadth = this.getBreadth(b);
        double span = this.m_hi - this.m_lo;
        double splo = MathLib.safeSqrt(this.m_prevlo);
        double spspan = MathLib.safeSqrt(this.m_prevhi) - splo;
        double vlo = Math.pow(10.0, Math.floor(MathLib.safeLog10(this.m_lo)));
        double slo = MathLib.safeSqrt(this.m_lo);
        double sspan = MathLib.safeSqrt(this.m_hi) - slo;
        Iterator iter = labels.tuples();
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            this.reset(item);
            double v = item.getDouble(VALUE);
            double x = span == 0.0 ? 0.0 : (MathLib.safeSqrt(v) - slo) / sspan * breadth;
            this.set(item, x, b);
        }
        Index index = labels.index(VALUE);
        double step = this.getLinearStep(span, breadth / span);
        if (step == 0.0) {
            step = 1.0;
        }
        for (double v = vlo; v <= this.m_hi; v += step) {
            double f;
            VisualItem item;
            double x = (MathLib.safeSqrt(v) - slo) / sspan * breadth;
            if (x < -0.5) continue;
            int r = index.get(v);
            if (r >= 0) {
                item = labels.getItem(r);
                item.setVisible(true);
                item.setEndVisible(true);
                continue;
            }
            item = labels.addItem();
            item.set(LABEL, (Object)this.m_nf.format(v));
            item.setDouble(VALUE, v);
            double d = f = spspan == 0.0 ? 0.0 : (MathLib.safeSqrt(v) - splo) / spspan;
            if (f <= 0.0 || f >= 1.0) {
                item.setStartVisible(true);
            }
            this.set(item, f * breadth, b);
            this.set(item, x, b);
        }
    }

    protected void logLayout(VisualTable labels) {
        Rectangle2D b = this.getLayoutBounds();
        double breadth = this.getBreadth(b);
        labels.clear();
        double llo = MathLib.safeLog10(this.m_lo);
        double lhi = MathLib.safeLog10(this.m_hi);
        double lspan = lhi - llo;
        double d = MathLib.log10(lhi - llo);
        int e = (int)Math.floor(d);
        int ilo = (int)Math.floor(llo);
        int ihi = (int)Math.ceil(lhi);
        double start = Math.pow(10.0, ilo);
        double end = Math.pow(10.0, ihi);
        double step = start * Math.pow(10.0, e);
        double v = start;
        double i = 0.0;
        while (v <= end) {
            double val = MathLib.safeLog10(v);
            if (i != 0.0 && Math.abs(val - (double)Math.round(val)) < 1.0E-4) {
                i = 0.0;
                step = 10.0 * step;
            }
            if (!((val = (val - llo) / lspan * breadth) < -0.5)) {
                VisualItem item = labels.addItem();
                this.set(item, val, b);
                String label = i == 0.0 ? this.m_nf.format(v) : null;
                item.set(LABEL, (Object)label);
                item.setDouble(VALUE, v);
            }
            v += step;
            i += 1.0;
        }
    }

    protected double getBreadth(Rectangle2D b) {
        switch (this.m_axis) {
            case 0: {
                return b.getWidth();
            }
        }
        return b.getHeight();
    }

    protected double adjust(double v) {
        switch (this.m_scale) {
            case 1: {
                return Math.pow(10.0, v);
            }
            case 2: {
                return v * v;
            }
        }
        return v;
    }

    protected double getLinearStep(double span, double scale) {
        double log10 = Math.log(span) / Math.log(10.0);
        double step = Math.pow(10.0, Math.floor(log10));
        double delta = step * scale / this.m_spacing;
        if (delta > 20.0) {
            step /= 20.0;
        } else if (delta > 10.0) {
            step /= 10.0;
        } else if (delta > 5.0) {
            step /= 5.0;
        } else if (delta > 4.0) {
            step /= 4.0;
        } else if (delta > 2.0) {
            step /= 2.0;
        } else if (delta < 1.0) {
            step *= 2.0;
        }
        return step;
    }

    protected void ordinalLayout(VisualTable labels) {
        ObjectRangeModel model = (ObjectRangeModel)this.m_model;
        double span = this.m_hi - this.m_lo;
        double pspan = this.m_prevhi - this.m_prevlo;
        Rectangle2D b = this.getLayoutBounds();
        double breadth = this.getBreadth(b);
        double scale = breadth / span;
        int step = this.getOrdinalStep(span, scale);
        if (step <= 0) {
            step = 1;
        }
        Iterator iter = labels.tuples();
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            this.reset(item);
            double v = item.getDouble(VALUE);
            double x = span == 0.0 ? 0.0 : (v - this.m_lo) / span * breadth;
            this.set(item, x, b);
        }
        Index index = labels.index(VALUE);
        int v = (int)this.m_lo;
        while ((double)v <= this.m_hi) {
            VisualItem item;
            int r = index.get((double)v);
            if (r >= 0) {
                item = labels.getItem(r);
                item.set(VisualItem.LABEL, (Object)model.getObject(v).toString());
                item.setVisible(true);
                item.setEndVisible(true);
            } else {
                double f;
                item = labels.addItem();
                item.set(VisualItem.LABEL, (Object)model.getObject(v).toString());
                item.setDouble(VisualItem.VALUE, (double)v);
                double d = f = pspan == 0.0 ? 0.0 : ((double)v - this.m_prevlo) / pspan;
                if (f <= 0.0 || f >= 1.0) {
                    item.setStartVisible(true);
                }
                this.set(item, f * breadth, b);
                this.set(item, ((double)v - this.m_lo) * breadth / span, b);
            }
            v += step;
        }
    }

    protected int getOrdinalStep(double span, double scale) {
        return scale >= this.m_spacing ? 1 : (int)Math.ceil(this.m_spacing / scale);
    }

    protected void set(VisualItem item, double xOrY, Rectangle2D b) {
        switch (this.m_axis) {
            case 0: {
                xOrY = this.m_asc ? xOrY + b.getMinX() : b.getMaxX() - xOrY;
                PrefuseLib.updateDouble(item, VisualItem.X, xOrY);
                PrefuseLib.updateDouble(item, VisualItem.Y, b.getMinY());
                PrefuseLib.updateDouble(item, VisualItem.X2, xOrY);
                PrefuseLib.updateDouble(item, VisualItem.Y2, b.getMaxY());
                break;
            }
            case 1: {
                xOrY = this.m_asc ? b.getMaxY() - xOrY - 1.0 : xOrY + b.getMinY();
                PrefuseLib.updateDouble(item, VisualItem.X, b.getMinX());
                PrefuseLib.updateDouble(item, VisualItem.Y, xOrY);
                PrefuseLib.updateDouble(item, VisualItem.X2, b.getMaxX());
                PrefuseLib.updateDouble(item, VisualItem.Y2, xOrY);
            }
        }
    }

    protected void reset(VisualItem item) {
        item.setVisible(false);
        item.setEndVisible(false);
        item.setStartStrokeColor(item.getStrokeColor());
        item.revertToDefault(VisualItem.STROKECOLOR);
        item.revertToDefault(VisualItem.ENDSTROKECOLOR);
        item.setStartTextColor(item.getTextColor());
        item.revertToDefault(VisualItem.TEXTCOLOR);
        item.revertToDefault(VisualItem.ENDTEXTCOLOR);
        item.setStartFillColor(item.getFillColor());
        item.revertToDefault(VisualItem.FILLCOLOR);
        item.revertToDefault(VisualItem.ENDFILLCOLOR);
    }

    protected void garbageCollect(VisualTable labels) {
        Iterator iter = labels.tuples();
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            if (item.isStartVisible() || item.isEndVisible()) continue;
            labels.removeTuple(item);
        }
    }

    protected VisualTable getTable() {
        TupleSet ts = this.m_vis.getGroup(this.m_group);
        if (ts == null) {
            Schema s = PrefuseLib.getAxisLabelSchema();
            VisualTable vt = this.m_vis.addTable(this.m_group, s);
            vt.index(VALUE);
            return vt;
        }
        if (ts instanceof VisualTable) {
            return (VisualTable)ts;
        }
        throw new IllegalStateException("Group already exists, not being used for labels");
    }
}

