/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DocumentSearchData;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.components.Markers;
import jsyntaxpane.util.SwingUtils;

public class QuickFindDialog
extends JDialog
implements DocumentListener,
ActionListener,
EscapeListener {
    private Markers.SimpleMarker marker = new Markers.SimpleMarker(Color.PINK);
    private WeakReference<JTextComponent> target;
    private WeakReference<DocumentSearchData> dsd;
    private int oldCaretPosition;
    private boolean escaped = false;
    private JButton jBtnNext;
    private JButton jBtnPrev;
    private JCheckBox jChkIgnoreCase;
    private JCheckBox jChkRegExp;
    private JCheckBox jChkWrap;
    private JLabel jLabel1;
    private JLabel jLblStatus;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;
    private JTextField jTxtFind;

    public QuickFindDialog(JTextComponent target, DocumentSearchData data) {
        super(ActionUtils.getFrameFor(target), false);
        this.initComponents();
        SwingUtils.addEscapeListener(this);
        this.dsd = new WeakReference<DocumentSearchData>(data);
    }

    public void showFor(JTextComponent target) {
        this.oldCaretPosition = target.getCaretPosition();
        Container view = target.getParent();
        Dimension wd = this.getSize();
        wd.width = target.getVisibleRect().width;
        Point loc = new Point(0, view.getHeight());
        this.setSize(wd);
        this.setLocationRelativeTo(view);
        SwingUtilities.convertPointToScreen(loc, view);
        this.setLocation(loc);
        this.jTxtFind.setFont(target.getFont());
        this.jTxtFind.getDocument().addDocumentListener(this);
        WindowAdapter closeListener = new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                target.getDocument().removeDocumentListener(QuickFindDialog.this);
                Markers.removeMarkers(target, QuickFindDialog.this.marker);
                if (QuickFindDialog.this.escaped) {
                    try {
                        Rectangle aRect = target.modelToView(QuickFindDialog.this.oldCaretPosition);
                        target.setCaretPosition(QuickFindDialog.this.oldCaretPosition);
                        target.scrollRectToVisible(aRect);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                QuickFindDialog.this.dispose();
            }
        };
        this.addWindowListener(closeListener);
        this.target = new WeakReference<JTextComponent>(target);
        Pattern p = ((DocumentSearchData)this.dsd.get()).getPattern();
        if (p != null) {
            this.jTxtFind.setText(p.pattern());
        }
        this.jChkWrap.setSelected(((DocumentSearchData)this.dsd.get()).isWrap());
        this.setVisible(true);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jSeparator1 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.jTxtFind = new JTextField();
        this.jBtnPrev = new JButton();
        this.jBtnNext = new JButton();
        this.jChkIgnoreCase = new JCheckBox();
        this.jChkRegExp = new JCheckBox();
        this.jChkWrap = new JCheckBox();
        this.jLblStatus = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.darkGray);
        this.setName("QuickFindDialog");
        this.setResizable(false);
        this.setUndecorated(true);
        this.jToolBar1.setBorder(BorderFactory.createEtchedBorder());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.add(this.jSeparator1);
        this.jLabel1.setLabelFor(this.jTxtFind);
        this.jLabel1.setText("Quick Find");
        this.jToolBar1.add(this.jLabel1);
        this.jTxtFind.setColumns(30);
        this.jTxtFind.setMaximumSize(new Dimension(200, 20));
        this.jTxtFind.setPreferredSize(new Dimension(150, 20));
        this.jToolBar1.add(this.jTxtFind);
        this.jBtnPrev.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/go-up.png")));
        this.jBtnPrev.setFocusable(false);
        this.jBtnPrev.setHorizontalTextPosition(0);
        this.jBtnPrev.setOpaque(false);
        this.jBtnPrev.setVerticalTextPosition(3);
        this.jBtnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuickFindDialog.this.jBtnPrevActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnPrev);
        this.jBtnNext.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/go-down.png")));
        this.jBtnNext.setFocusable(false);
        this.jBtnNext.setHorizontalTextPosition(0);
        this.jBtnNext.setMargin(new Insets(2, 2, 2, 2));
        this.jBtnNext.setOpaque(false);
        this.jBtnNext.setVerticalTextPosition(3);
        this.jBtnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuickFindDialog.this.jBtnNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnNext);
        this.jChkIgnoreCase.setMnemonic('C');
        this.jChkIgnoreCase.setText("Ignore Case");
        this.jChkIgnoreCase.setFocusable(false);
        this.jChkIgnoreCase.setOpaque(false);
        this.jChkIgnoreCase.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jChkIgnoreCase);
        this.jChkIgnoreCase.addActionListener(this);
        this.jChkRegExp.setMnemonic('R');
        this.jChkRegExp.setText("Reg Exp");
        this.jChkRegExp.setFocusable(false);
        this.jChkRegExp.setOpaque(false);
        this.jChkRegExp.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jChkRegExp);
        this.jChkRegExp.addActionListener(this);
        this.jChkWrap.setMnemonic('W');
        this.jChkWrap.setText("Wrap");
        this.jChkWrap.setFocusable(false);
        this.jChkWrap.setOpaque(false);
        this.jChkWrap.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jChkWrap);
        this.jChkWrap.addActionListener(this);
        this.jLblStatus.setFont(this.jLblStatus.getFont().deriveFont((float)this.jLblStatus.getFont().getSize() - 2.0f));
        this.jLblStatus.setForeground(Color.red);
        this.jToolBar1.add(this.jLblStatus);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 684, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -2, -1, -2));
        this.pack();
    }

    private void jBtnNextActionPerformed(ActionEvent evt) {
        if (((DocumentSearchData)this.dsd.get()).doFindNext((JTextComponent)this.target.get())) {
            this.jLblStatus.setText(null);
        } else {
            this.jLblStatus.setText("not found");
        }
    }

    private void jBtnPrevActionPerformed(ActionEvent evt) {
        if (((DocumentSearchData)this.dsd.get()).doFindPrev((JTextComponent)this.target.get())) {
            this.jLblStatus.setText(null);
        } else {
            this.jLblStatus.setText("not found");
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateFind();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateFind();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateFind();
    }

    private void updateFind() {
        JTextComponent t = (JTextComponent)this.target.get();
        DocumentSearchData d = (DocumentSearchData)this.dsd.get();
        String toFind = this.jTxtFind.getText();
        if (toFind == null || toFind.isEmpty()) {
            this.jLblStatus.setText(null);
            return;
        }
        try {
            d.setWrap(this.jChkWrap.isSelected());
            d.setPattern(toFind, this.jChkRegExp.isSelected(), this.jChkIgnoreCase.isSelected());
            this.jLblStatus.setText(null);
            t.setCaretPosition(this.oldCaretPosition);
            if (!d.doFindNext(t)) {
                this.jLblStatus.setText("Not found");
            } else {
                this.jLblStatus.setText(null);
            }
        }
        catch (PatternSyntaxException e) {
            this.jLblStatus.setText(e.getDescription());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.updateFind();
        }
    }

    @Override
    public void escapePressed() {
        this.escaped = true;
        this.setVisible(false);
    }

    static /* synthetic */ Markers.SimpleMarker access$000(QuickFindDialog x0) {
        return x0.marker;
    }

    static /* synthetic */ boolean access$100(QuickFindDialog x0) {
        return x0.escaped;
    }

    static /* synthetic */ int access$200(QuickFindDialog x0) {
        return x0.oldCaretPosition;
    }

    static /* synthetic */ void access$300(QuickFindDialog x0, ActionEvent x1) {
        x0.jBtnPrevActionPerformed(x1);
    }

    static /* synthetic */ void access$400(QuickFindDialog x0, ActionEvent x1) {
        x0.jBtnNextActionPerformed(x1);
    }
}

