/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.util.StringUtils;
import jsyntaxpane.util.SwingUtils;

public class ComboCompletionDialog
extends JDialog
implements EscapeListener {
    private String result = null;
    private JTextComponent target;
    public String escapeChars = ";(= \t\n\r";
    public List<String> items;
    private JList jLstItems;
    private JScrollPane jScrollPane1;
    private JTextField jTxtItem;

    public ComboCompletionDialog(JTextComponent target) {
        super(ActionUtils.getFrameFor(target), true);
        this.initComponents();
        this.jTxtItem.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }
        });
        this.jTxtItem.setFocusTraversalKeysEnabled(false);
        this.target = target;
        SwingUtils.addEscapeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFor(String abbrev, List<String> items) {
        this.items = items;
        try {
            Window window = SwingUtilities.getWindowAncestor(this.target);
            Rectangle rt = this.target.modelToView(this.target.getSelectionStart());
            Point loc = new Point(rt.x, rt.y);
            this.setLocationRelativeTo(window);
            loc = SwingUtilities.convertPoint(this.target, loc, window);
            SwingUtilities.convertPointToScreen(loc, window);
            this.setLocation(loc);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ComboCompletionDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            Font font = this.target.getFont();
            this.jTxtItem.setFont(font);
            this.jLstItems.setFont(font);
            this.doLayout();
            this.jTxtItem.setText(abbrev);
            this.refilterList();
            this.setVisible(true);
        }
    }

    private void refilterList() {
        String prefix = this.jTxtItem.getText();
        Vector<String> filtered = new Vector<String>();
        Object selected = this.jLstItems.getSelectedValue();
        for (String s : this.items) {
            if (!StringUtils.camelCaseMatch(s, prefix)) continue;
            filtered.add(s);
        }
        this.jLstItems.setListData(filtered);
        if (selected != null && filtered.contains(selected)) {
            this.jLstItems.setSelectedValue(selected, true);
        } else {
            this.jLstItems.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jTxtItem = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jLstItems = new JList();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setUndecorated(true);
        this.jTxtItem.setBorder(null);
        this.jTxtItem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ComboCompletionDialog.this.jTxtItemKeyPressed(evt);
            }
        });
        this.jLstItems.setSelectionMode(0);
        this.jLstItems.setFocusable(false);
        this.jLstItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ComboCompletionDialog.this.jLstItemsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLstItems);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTxtItem, -1, 375, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTxtItem, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 111, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTxtItemKeyPressed(KeyEvent evt) {
        int i = this.jLstItems.getSelectedIndex();
        switch (evt.getKeyCode()) {
            case 27: {
                this.result = this.jTxtItem.getText();
                this.target.replaceSelection(this.result);
                this.setVisible(false);
                return;
            }
            case 40: {
                if (i < this.jLstItems.getModel().getSize() - 1) {
                    ++i;
                }
                this.jLstItems.setSelectedIndex(i);
                this.jLstItems.ensureIndexIsVisible(i);
                break;
            }
            case 38: {
                if (i > 0) {
                    --i;
                }
                this.jLstItems.setSelectedIndex(i);
                this.jLstItems.ensureIndexIsVisible(i);
            }
        }
        if (this.escapeChars.indexOf(evt.getKeyChar()) >= 0) {
            this.result = this.jLstItems.getSelectedIndex() >= 0 ? this.jLstItems.getSelectedValue().toString() : this.jTxtItem.getText();
            char pressed = evt.getKeyChar();
            if (pressed != '\n') {
                this.result = this.result + (pressed == '\t' ? (char)' ' : (char)pressed);
            }
            this.target.replaceSelection(this.result);
            this.setVisible(false);
        }
    }

    private void jLstItemsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            String selected = this.jLstItems.getSelectedValue().toString();
            this.target.replaceSelection(selected);
            this.setVisible(false);
        }
    }

    @Override
    public void escapePressed() {
        this.setVisible(false);
    }

    static /* synthetic */ void access$000(ComboCompletionDialog x0) {
        x0.refilterList();
    }

    static /* synthetic */ void access$100(ComboCompletionDialog x0, KeyEvent x1) {
        x0.jTxtItemKeyPressed(x1);
    }

    static /* synthetic */ void access$200(ComboCompletionDialog x0, MouseEvent x1) {
        x0.jLstItemsMouseClicked(x1);
    }
}

