/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlPrettifyAction
extends DefaultSyntaxAction {
    static Transformer transformer;
    static DocumentBuilderFactory docBuilderFactory;
    static DocumentBuilder docBuilder;

    public XmlPrettifyAction() {
        super("XML_PRETTIFY");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (transformer == null) {
            return;
        }
        JTextComponent target = this.getTextComponent(e);
        try {
            SyntaxDocument sdoc = ActionUtils.getSyntaxDocument(target);
            StringWriter out = new StringWriter(sdoc.getLength());
            StringReader reader = new StringReader(target.getText());
            InputSource src = new InputSource(reader);
            Document doc = this.getDocBuilder().parse(src);
            XmlPrettifyAction.getTransformer().transform(new DOMSource(doc), new StreamResult(out));
            target.setText(out.toString());
        }
        catch (SAXParseException ex) {
            XmlPrettifyAction.showErrorMessage(target, String.format("XML error: %s\nat(%d, %d)", ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber()));
            ActionUtils.setCaretPosition(target, ex.getLineNumber(), ex.getColumnNumber() - 1);
        }
        catch (TransformerException ex) {
            XmlPrettifyAction.showErrorMessage(target, ex.getMessageAndLocation());
        }
        catch (SAXException ex) {
            XmlPrettifyAction.showErrorMessage(target, ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            XmlPrettifyAction.showErrorMessage(target, ex.getLocalizedMessage());
        }
    }

    private static void showErrorMessage(JTextComponent text, String msg) {
        Window parent = SwingUtilities.getWindowAncestor(text);
        JOptionPane.showMessageDialog(parent, msg, "JsyntaxPAne XML", 0);
    }

    public static Transformer getTransformer() {
        if (transformer == null) {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            try {
                transformer = tfactory.newTransformer();
            }
            catch (TransformerConfigurationException ex) {
                throw new IllegalArgumentException("Unable to create transformer. ", ex);
            }
        }
        return transformer;
    }

    public void setIndent(String text) {
        XmlPrettifyAction.getTransformer().setOutputProperty("indent", text);
    }

    public void setStandAlone(String text) {
        XmlPrettifyAction.getTransformer().setOutputProperty("standalone", text);
    }

    public void setSOmitDeclaration(String text) {
        XmlPrettifyAction.getTransformer().setOutputProperty("omit-xml-declaration", text);
    }

    public void setIndentAmount(String text) {
        XmlPrettifyAction.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", text);
    }

    public void setIgnoreComments(String ic) {
        XmlPrettifyAction.getDocBuilderFactory().setIgnoringComments(Boolean.parseBoolean(ic));
    }

    public void setIgnoreWhiteSpace(String value) {
        XmlPrettifyAction.getDocBuilderFactory().setIgnoringElementContentWhitespace(Boolean.parseBoolean(value));
    }

    public static DocumentBuilderFactory getDocBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return docBuilderFactory;
    }

    public DocumentBuilder getDocBuilder() {
        if (docBuilder == null) {
            try {
                docBuilder = XmlPrettifyAction.getDocBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new IllegalArgumentException("Unable to create document builder", ex);
            }
        }
        return docBuilder;
    }
}

