/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import jsyntaxpane.SyntaxDocument;

public class CompoundUndoMan
extends UndoManager {
    private SyntaxDocument doc;
    private CompoundEdit compoundEdit;
    private boolean startCombine = false;

    public CompoundUndoMan(SyntaxDocument doc) {
        this.doc = doc;
        doc.addUndoableEditListener(this);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        AbstractDocument.DefaultDocumentEvent docEvt = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
            this.startCombine = false;
            return;
        }
        if (this.startCombine || Math.abs(docEvt.getLength()) == 1) {
            this.compoundEdit.addEdit(e.getEdit());
            this.startCombine = false;
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit());
    }

    private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
        AbstractDocument.DefaultDocumentEvent docEvt = (AbstractDocument.DefaultDocumentEvent)anEdit;
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(anEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    public void startCombine() {
        this.startCombine = true;
    }

    static /* synthetic */ CompoundEdit access$000(CompoundUndoMan x0) {
        return x0.compoundEdit;
    }

    static /* synthetic */ CompoundEdit access$002(CompoundUndoMan x0, CompoundEdit x1) {
        x0.compoundEdit = x1;
        return x0.compoundEdit;
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (CompoundUndoMan.this.compoundEdit != null) {
                CompoundUndoMan.this.compoundEdit.end();
            }
            super.undo();
            CompoundUndoMan.this.compoundEdit = null;
        }
    }
}

