/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)TimestampDataType.class);

    TimestampDataType() {
        super("TIMESTAMP", 93, Timestamp.class, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Timestamp) {
            return value;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Timestamp(date.getTime());
        }
        if (value instanceof Long) {
            Long date = (Long)value;
            return new Timestamp(date);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.length() == 10) {
                try {
                    long time = java.sql.Date.valueOf(stringValue).getTime();
                    return new Timestamp(time);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        throw new TypeCastException(value, this);
    }

    public boolean isDateTime() {
        logger.debug("isDateTime() - start");
        return true;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        Timestamp value;
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        if ((value = resultSet.getTimestamp(column)) == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        statement.setTimestamp(column, (Timestamp)this.typeCast(value));
    }
}

