/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import [Ljava.lang.String;;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.CachedResultSetTableFactory;
import org.dbunit.database.DefaultMetadataHandler;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.database.statement.PreparedStatementFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.filter.IColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConfig {
    private static final Logger logger = LoggerFactory.getLogger((Class)DatabaseConfig.class);
    public static final String PROPERTY_STATEMENT_FACTORY = "http://www.dbunit.org/properties/statementFactory";
    public static final String PROPERTY_RESULTSET_TABLE_FACTORY = "http://www.dbunit.org/properties/resultSetTableFactory";
    public static final String PROPERTY_DATATYPE_FACTORY = "http://www.dbunit.org/properties/datatypeFactory";
    public static final String PROPERTY_ESCAPE_PATTERN = "http://www.dbunit.org/properties/escapePattern";
    public static final String PROPERTY_TABLE_TYPE = "http://www.dbunit.org/properties/tableType";
    public static final String PROPERTY_PRIMARY_KEY_FILTER = "http://www.dbunit.org/properties/primaryKeyFilter";
    public static final String PROPERTY_BATCH_SIZE = "http://www.dbunit.org/properties/batchSize";
    public static final String PROPERTY_FETCH_SIZE = "http://www.dbunit.org/properties/fetchSize";
    public static final String PROPERTY_METADATA_HANDLER = "http://www.dbunit.org/properties/metadataHandler";
    public static final ConfigProperty[] ALL_PROPERTIES = new ConfigProperty[]{new ConfigProperty("http://www.dbunit.org/properties/statementFactory", IStatementFactory.class, false), new ConfigProperty("http://www.dbunit.org/properties/resultSetTableFactory", IResultSetTableFactory.class, false), new ConfigProperty("http://www.dbunit.org/properties/datatypeFactory", IDataTypeFactory.class, false), new ConfigProperty("http://www.dbunit.org/properties/escapePattern", String.class, true), new ConfigProperty("http://www.dbunit.org/properties/tableType", String;.class, false), new ConfigProperty("http://www.dbunit.org/properties/primaryKeyFilter", IColumnFilter.class, true), new ConfigProperty("http://www.dbunit.org/properties/batchSize", Integer.class, false), new ConfigProperty("http://www.dbunit.org/properties/fetchSize", Integer.class, false), new ConfigProperty("http://www.dbunit.org/properties/metadataHandler", IMetadataHandler.class, false)};
    public static final String FEATURE_CASE_SENSITIVE_TABLE_NAMES = "http://www.dbunit.org/features/caseSensitiveTableNames";
    public static final String FEATURE_QUALIFIED_TABLE_NAMES = "http://www.dbunit.org/features/qualifiedTableNames";
    public static final String FEATURE_BATCHED_STATEMENTS = "http://www.dbunit.org/features/batchedStatements";
    public static final String FEATURE_DATATYPE_WARNING = "http://www.dbunit.org/features/datatypeWarning";
    public static final String FEATURE_SKIP_ORACLE_RECYCLEBIN_TABLES = "http://www.dbunit.org/features/skipOracleRecycleBinTables";
    public static final String[] ALL_FEATURES = new String[]{"http://www.dbunit.org/features/caseSensitiveTableNames", "http://www.dbunit.org/features/qualifiedTableNames", "http://www.dbunit.org/features/batchedStatements", "http://www.dbunit.org/features/datatypeWarning", "http://www.dbunit.org/features/skipOracleRecycleBinTables"};
    private static final DefaultDataTypeFactory DEFAULT_DATA_TYPE_FACTORY = new DefaultDataTypeFactory();
    private static final PreparedStatementFactory PREPARED_STATEMENT_FACTORY = new PreparedStatementFactory();
    private static final CachedResultSetTableFactory RESULT_SET_TABLE_FACTORY = new CachedResultSetTableFactory();
    private static final String DEFAULT_ESCAPE_PATTERN = null;
    private static final String[] DEFAULT_TABLE_TYPE = new String[]{"TABLE"};
    private static final Integer DEFAULT_BATCH_SIZE = new Integer(100);
    private static final Integer DEFAULT_FETCH_SIZE = new Integer(100);
    private Set _featuresSet = new HashSet();
    private Map _propertyMap = new HashMap();
    private final Configurator configurator;
    static /* synthetic */ Class class$org$dbunit$database$DatabaseConfig$Configurator;

    public DatabaseConfig() {
        this.setFeature(FEATURE_BATCHED_STATEMENTS, false);
        this.setFeature(FEATURE_QUALIFIED_TABLE_NAMES, false);
        this.setFeature(FEATURE_CASE_SENSITIVE_TABLE_NAMES, false);
        this.setFeature(FEATURE_DATATYPE_WARNING, true);
        this.setProperty(PROPERTY_STATEMENT_FACTORY, PREPARED_STATEMENT_FACTORY);
        this.setProperty(PROPERTY_RESULTSET_TABLE_FACTORY, RESULT_SET_TABLE_FACTORY);
        this.setProperty(PROPERTY_DATATYPE_FACTORY, DEFAULT_DATA_TYPE_FACTORY);
        this.setProperty(PROPERTY_ESCAPE_PATTERN, DEFAULT_ESCAPE_PATTERN);
        this.setProperty(PROPERTY_TABLE_TYPE, DEFAULT_TABLE_TYPE);
        this.setProperty(PROPERTY_BATCH_SIZE, DEFAULT_BATCH_SIZE);
        this.setProperty(PROPERTY_FETCH_SIZE, DEFAULT_FETCH_SIZE);
        this.setProperty(PROPERTY_METADATA_HANDLER, new DefaultMetadataHandler());
        this.configurator = new Configurator(this);
    }

    protected Configurator getConfigurator() {
        return this.configurator;
    }

    public void setFeature(String name, boolean value) {
        logger.debug("setFeature(name={}, value={}) - start", (Object)name, (Object)String.valueOf(value));
        if (value) {
            this._featuresSet.add(name);
        } else {
            this._featuresSet.remove(name);
        }
    }

    public boolean getFeature(String name) {
        logger.debug("getFeature(name={}) - start", (Object)name);
        return this._featuresSet.contains(name);
    }

    public void setProperty(String name, Object value) {
        logger.debug("setProperty(name={}, value={}) - start", (Object)name, value);
        this.checkObjectAllowed(name, value);
        this._propertyMap.put(name, value);
    }

    public Object getProperty(String name) {
        return this._propertyMap.get(name);
    }

    protected void checkObjectAllowed(String property, Object value) {
        ConfigProperty prop = DatabaseConfig.findByName(property);
        if (prop != null) {
            if (value == null) {
                if (prop.isNullable()) {
                    return;
                }
                throw new IllegalArgumentException("The property '" + property + "' is not nullable.");
            }
            Class allowedPropType = prop.getPropertyType();
            if (!allowedPropType.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Cannot cast object of type '" + value.getClass() + "' to allowed type '" + allowedPropType + "'.");
            }
        } else {
            logger.info("Unknown property '" + property + "'. Cannot validate the type of the object to be set." + " Please notify a developer to update the list of properties.");
        }
    }

    public static final ConfigProperty findByName(String property) {
        for (int i = 0; i < ALL_PROPERTIES.length; ++i) {
            if (!ALL_PROPERTIES[i].getProperty().equals(property)) continue;
            return ALL_PROPERTIES[i];
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_featuresSet=").append(this._featuresSet);
        sb.append(", _propertyMap=").append(this._propertyMap);
        sb.append("]");
        return sb.toString();
    }

    protected static class Configurator {
        private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$DatabaseConfig$Configurator == null ? (class$org$dbunit$database$DatabaseConfig$Configurator = DatabaseConfig.class$("org.dbunit.database.DatabaseConfig$Configurator")) : class$org$dbunit$database$DatabaseConfig$Configurator));
        private DatabaseConfig config;

        public Configurator(DatabaseConfig config) {
            if (config == null) {
                throw new NullPointerException("The parameter 'config' must not be null");
            }
            this.config = config;
        }

        void configureStatement(Statement stmt) throws SQLException {
            logger.trace("configureStatement(stmt={}) - start", (Object)stmt);
            Integer fetchSize = (Integer)this.config.getProperty(DatabaseConfig.PROPERTY_FETCH_SIZE);
            stmt.setFetchSize(fetchSize);
            logger.debug("Statement fetch size set to {}", (Object)fetchSize);
        }
    }

    public static class ConfigProperty {
        private String property;
        private Class propertyType;
        private boolean nullable;

        public ConfigProperty(String property, Class propertyType, boolean nullable) {
            if (property == null) {
                throw new NullPointerException("The parameter 'property' must not be null");
            }
            if (propertyType == null) {
                throw new NullPointerException("The parameter 'propertyType' must not be null");
            }
            this.property = property;
            this.propertyType = propertyType;
            this.nullable = nullable;
        }

        public String getProperty() {
            return this.property;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigProperty other = (ConfigProperty)obj;
            return !(this.property == null ? other.property != null : !this.property.equals(other.property));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName()).append("[");
            sb.append("property=").append(this.property);
            sb.append(", propertyType=").append(this.propertyType);
            sb.append(", nullable=").append(this.nullable);
            sb.append("]");
            return sb.toString();
        }
    }
}

