/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.jailer.xml.NodeVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static final String NS_URI = "http://jailer.sf.net/";
    public static final String NS_PREFIX = "j";
    public static final String ASSOCIATION_TAG = "assoc";
    public static final String SQL_PREFIX = "SQL:";
    private static Transformer transformer;

    public static Document parse(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        XmlUtil.removeWhitespaces((Element)document.getChildNodes().item(0));
        return document;
    }

    private static void removeWhitespaces(Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n instanceof Element) {
                XmlUtil.removeWhitespaces((Element)n);
                ++i;
                continue;
            }
            if (n instanceof Text && ((Text)n).getTextContent().trim().length() == 0) {
                element.removeChild(n);
                continue;
            }
            ++i;
        }
    }

    public static String build(Document xmlDocument) throws TransformerException {
        if (transformer == null) {
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            try {
                xformFactory.setAttribute("indent-number", new Integer(4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            transformer = xformFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
        }
        StringWriter out = new StringWriter();
        transformer.transform(new DOMSource(xmlDocument), new StreamResult(out));
        return out.getBuffer().toString();
    }

    public static String asElementName(String x) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (!Character.isUpperCase(c) && !Character.isLowerCase(c) && !Character.isDigit(c) && c != '-' && c != '_') continue;
            sb.append(c);
        }
        String elementName = sb.toString();
        if (elementName.length() == 0 || !Character.isUpperCase(elementName.charAt(0)) && !Character.isLowerCase(elementName.charAt(0))) {
            return "e" + elementName;
        }
        return elementName;
    }

    public static void visitDocumentNodes(Document document, NodeVisitor visitor) {
        if (document.getChildNodes().getLength() > 0) {
            XmlUtil.visitNodes(document.getChildNodes().item(0), true, visitor);
        }
    }

    private static void visitNodes(Node node, boolean nodeIsRoot, NodeVisitor visitor) {
        if (node instanceof Text) {
            String text = ((Text)node).getTextContent().trim();
            if (text.length() > 0) {
                visitor.visitText(text);
            }
        } else if (node instanceof Comment) {
            visitor.visitComment(((Comment)node).getTextContent());
        } else if (node instanceof Element) {
            if (NS_URI.equals(node.getNamespaceURI()) && ASSOCIATION_TAG.equals(node.getLocalName()) && ((Element)node).getTextContent() != null) {
                visitor.visitAssociationElement(((Element)node).getTextContent().trim());
            } else {
                Element e = (Element)node;
                NamedNodeMap attr = e.getAttributes();
                String[] aNames = new String[]{};
                String[] aValues = new String[]{};
                if (attr != null) {
                    aNames = new String[attr.getLength()];
                    aValues = new String[attr.getLength()];
                    for (int i = 0; i < attr.getLength(); ++i) {
                        Node a = attr.item(i);
                        aNames[i] = ((Attr)a).getName();
                        aValues[i] = ((Attr)a).getValue();
                    }
                }
                visitor.visitElementStart(e.getTagName(), nodeIsRoot, aNames, aValues);
                NodeList children = e.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    XmlUtil.visitNodes(children.item(i), false, visitor);
                }
                visitor.visitElementEnd(e.getTagName(), nodeIsRoot);
            }
        }
    }

    public static TransformerHandler createTransformerHandler(String commentHeader, String rootTag, StreamResult streamResult, Charset charset) throws TransformerFactoryConfigurationError, TransformerConfigurationException, SAXException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            tf.setAttribute("indent-number", new Integer(2));
        }
        catch (Exception e) {
            // empty catch block
        }
        TransformerHandler transformerHandler = tf.newTransformerHandler();
        Transformer serializer = transformerHandler.getTransformer();
        serializer.setOutputProperty("encoding", charset.name());
        serializer.setOutputProperty("method", "xml");
        serializer.setOutputProperty("indent", "yes");
        transformerHandler.setResult(streamResult);
        transformerHandler.startDocument();
        String newline = System.getProperty("line.separator");
        if (newline == null) {
            newline = "\n";
        }
        commentHeader = (newline + commentHeader).replaceAll("\\n--", newline + " ");
        transformerHandler.characters("\n".toCharArray(), 0, 1);
        transformerHandler.comment(commentHeader.toCharArray(), 0, commentHeader.toCharArray().length);
        transformerHandler.characters("\n".toCharArray(), 0, 1);
        if (rootTag.length() > 0) {
            transformerHandler.startElement("", "", rootTag, null);
        }
        return transformerHandler;
    }
}

