/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.util.Base64;
import net.sf.jailer.util.SqlUtil;
import net.sf.jailer.xml.NodeVisitor;
import net.sf.jailer.xml.XmlUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlRowWriter {
    private final TransformerHandler transformerHandler;
    private final String rootTag;
    final SimpleDateFormat datePattern;
    final SimpleDateFormat timestampPattern;
    private int ifLevel = 0;
    private final Map<Table, Map<String, Integer>> typeCachesForStringKey = new HashMap<Table, Map<String, Integer>>();

    public XmlRowWriter(OutputStream out, String commentHeader, String rootTag, String datePattern, String timestampPattern, Charset charset) throws SAXException, TransformerConfigurationException {
        this.rootTag = rootTag;
        this.datePattern = new SimpleDateFormat(datePattern);
        this.timestampPattern = new SimpleDateFormat(timestampPattern);
        StreamResult streamResult = new StreamResult(new OutputStreamWriter(out, charset));
        this.transformerHandler = XmlUtil.createTransformerHandler(commentHeader, rootTag, streamResult, charset);
    }

    public void close() throws SAXException {
        if (this.rootTag.length() > 0) {
            this.transformerHandler.endElement("", "", this.rootTag);
        }
        this.transformerHandler.endDocument();
    }

    public void startList(Association association) throws SAXException {
        if (association != null && association.getAggregationSchema() == AggregationSchema.EXPLICIT_LIST && this.ifLevel == 0) {
            this.transformerHandler.startElement(null, null, association.getAggregationTagName(), null);
        }
    }

    public void endList(Association association) throws SAXException {
        if (association != null && association.getAggregationSchema() == AggregationSchema.EXPLICIT_LIST && this.ifLevel == 0) {
            this.transformerHandler.endElement(null, null, association.getAggregationTagName());
        }
    }

    public abstract class XmlWritingNodeVisitor
    implements NodeVisitor {
        private final ResultSet resultSet;
        private final ResultSetMetaData resultSetMetaData;
        private final Table table;
        private final Association association;
        private final Session session;
        private int nr = 0;
        String jailerNamespaceDeclaration = "xmlns:j";

        public XmlWritingNodeVisitor(ResultSet resultSet, ResultSetMetaData resultSetMetaData, Table table, Association association, Session session) {
            this.resultSet = resultSet;
            this.resultSetMetaData = resultSetMetaData;
            this.table = table;
            this.association = association;
            this.session = session;
        }

        private String toXml(String text, boolean returnNull) {
            if (text != null && text.startsWith("SQL:")) {
                String columnName = "C" + this.nr++;
                try {
                    int type;
                    HashMap<String, Integer> typeCache = (HashMap<String, Integer>)XmlRowWriter.this.typeCachesForStringKey.get(this.table);
                    if (typeCache == null) {
                        typeCache = new HashMap<String, Integer>();
                        XmlRowWriter.this.typeCachesForStringKey.put(this.table, typeCache);
                    }
                    if (((type = SqlUtil.getColumnType(this.resultSet, this.resultSetMetaData, columnName, typeCache)) == 2004 || type == 2005) && this.session.dbms != DBMS.SQLITE) {
                        Object object = this.resultSet.getObject(columnName);
                        if (returnNull && (object == null || this.resultSet.wasNull())) {
                            return null;
                        }
                        if (object instanceof Blob) {
                            Blob blob = (Blob)object;
                            byte[] blobValue = blob.getBytes(1L, (int)blob.length());
                            return Base64.encodeBytes(blobValue);
                        }
                        if (object instanceof Clob) {
                            Clob clobValue = (Clob)object;
                            int length = (int)clobValue.length();
                            if (length > 0) {
                                return clobValue.getSubString(1L, length);
                            }
                            return "";
                        }
                    } else {
                        Object o = SqlUtil.getObject(this.resultSet, this.resultSetMetaData, columnName, typeCache);
                        if (returnNull && (o == null || this.resultSet.wasNull())) {
                            return null;
                        }
                        if (o != null) {
                            String value = o instanceof Timestamp ? XmlRowWriter.this.timestampPattern.format((Timestamp)o) : (o instanceof Date ? XmlRowWriter.this.datePattern.format((Date)o) : o.toString());
                            return value;
                        }
                    }
                    return "";
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return text;
        }

        @Override
        public void visitComment(String comment) {
            try {
                if (XmlRowWriter.this.ifLevel == 0) {
                    XmlRowWriter.this.transformerHandler.comment(comment.toCharArray(), 0, comment.length());
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visitElementEnd(String elementName, boolean isRoot) {
            if (XmlRowWriter.this.ifLevel > 0) {
                --XmlRowWriter.this.ifLevel;
            } else {
                try {
                    if (!isRoot || this.association == null || this.association.getAggregationSchema() != AggregationSchema.FLAT) {
                        String tagName = isRoot && this.association != null && this.association.getAggregationSchema() != AggregationSchema.EXPLICIT_LIST ? this.association.getAggregationTagName() : elementName;
                        XmlRowWriter.this.transformerHandler.endElement("", "", tagName);
                    }
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void visitElementStart(String elementName, boolean isRoot, String[] aNames, String[] aValues) {
            if (XmlRowWriter.this.ifLevel > 0) {
                ++XmlRowWriter.this.ifLevel;
            }
            try {
                AttributesImpl attr = null;
                boolean cond = true;
                if (aNames.length > 0) {
                    attr = new AttributesImpl();
                    for (int i = 0; i < aNames.length; ++i) {
                        if (aNames[i].equals("j:if-not-null")) {
                            if (this.toXml(aValues[i], true) != null || XmlRowWriter.this.ifLevel != 0) continue;
                            cond = false;
                            continue;
                        }
                        if (aNames[i].equals("j:if-null")) {
                            if (this.toXml(aValues[i], true) == null || XmlRowWriter.this.ifLevel != 0) continue;
                            cond = false;
                            continue;
                        }
                        if (aNames[i].equals(this.jailerNamespaceDeclaration)) continue;
                        attr.addAttribute("", "", aNames[i], "CDATA", this.toXml(aValues[i], false));
                    }
                }
                if (XmlRowWriter.this.ifLevel == 0) {
                    if (!cond) {
                        ++XmlRowWriter.this.ifLevel;
                    } else if (!isRoot || this.association == null || this.association.getAggregationSchema() != AggregationSchema.FLAT) {
                        String tagName = isRoot && this.association != null && this.association.getAggregationSchema() != AggregationSchema.EXPLICIT_LIST ? this.association.getAggregationTagName() : elementName;
                        XmlRowWriter.this.transformerHandler.startElement("", "", tagName, attr);
                    }
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visitText(String text) {
            text = this.toXml(text, false);
            try {
                if (XmlRowWriter.this.ifLevel == 0) {
                    XmlRowWriter.this.transformerHandler.characters(text.toCharArray(), 0, text.length());
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

