/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.entitygraph.EntityGraph;
import net.sf.jailer.util.SqlScriptExecutor;
import net.sf.jailer.util.SqlUtil;
import net.sf.jailer.xml.NodeVisitor;
import net.sf.jailer.xml.XmlRowWriter;
import net.sf.jailer.xml.XmlUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlExportTransformer
extends Session.AbstractResultSetReader {
    private Table table;
    private final XmlRowWriter xmlRowWriter;
    public static long numberOfExportedEntities;
    public static long numberOfExportedLOBs;
    private final EntityGraph entityGraph;
    private final Set<Table> totalProgress;
    private final Set<Table> cyclicAggregatedTables;
    private static final Logger _log;
    private Map<Table, Map<String, Integer>> typeCache = new HashMap<Table, Map<String, Integer>>();
    private final Session session;
    private Map<Table, Map<String, Association>> associationCache = new HashMap<Table, Map<String, Association>>();
    private Map<Table, TableMapping> tableMappings = new HashMap<Table, TableMapping>();

    public XmlExportTransformer(OutputStream out, String commentHeader, EntityGraph entityGraph, Set<Table> totalProgress, Set<Table> cyclicAggregatedTables, String rootTag, String datePattern, String timestampPattern, Session session, Charset charset) throws TransformerConfigurationException, SAXException {
        this.xmlRowWriter = new XmlRowWriter(out, commentHeader, rootTag, datePattern, timestampPattern, charset);
        this.entityGraph = entityGraph;
        this.totalProgress = totalProgress;
        this.cyclicAggregatedTables = cyclicAggregatedTables;
        this.session = session;
    }

    @Override
    public void readCurrentRow(ResultSet resultSet) throws SQLException {
        try {
            this.writeEntity(this.table, null, resultSet, new ArrayList<String>());
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeEntity(Table table, Association association, final ResultSet resultSet, final List<String> ancestors) throws SQLException, SAXException, ParserConfigurationException, IOException {
        StringBuilder sb = new StringBuilder(table.getName() + "(");
        boolean f = true;
        int i = 0;
        for (Column pk : table.primaryKey.getColumns()) {
            if (!f) {
                sb.append(", ");
            }
            f = false;
            sb.append(SqlUtil.toSql(SqlUtil.getObject(resultSet, this.getMetaData(resultSet), "PK" + i++, this.getTypeCache(table)), this.session));
        }
        sb.append(")");
        String primaryKey = sb.toString();
        if (ancestors.contains(primaryKey)) {
            throw new RuntimeException("cyclic aggregation: " + primaryKey + " aggregates itself");
        }
        ancestors.add(primaryKey);
        TableMapping tableMapping = this.getTableMapping(table);
        Map<String, Association> associationMap = this.associationCache.get(table);
        if (associationMap == null) {
            associationMap = new HashMap<String, Association>();
            for (Association a : table.associations) {
                associationMap.put(a.getName(), a);
            }
            this.associationCache.put(table, associationMap);
        }
        final Map<String, Association> finalAssociationMap = associationMap;
        Document document = tableMapping.template;
        XmlRowWriter xmlRowWriter = this.xmlRowWriter;
        xmlRowWriter.getClass();
        XmlUtil.visitDocumentNodes(document, new XmlRowWriter.XmlWritingNodeVisitor(xmlRowWriter, resultSet, this.getMetaData(resultSet), table, association, this.session){
            {
                XmlRowWriter xmlRowWriter = x0;
                xmlRowWriter.getClass();
                super(xmlRowWriter, x1, x2, x3, x4, x5);
            }

            @Override
            public void visitAssociationElement(String associationName) {
                final Association sa = (Association)finalAssociationMap.get(associationName);
                if (sa != null && XmlExportTransformer.this.totalProgress.contains(sa.destination) && sa.getAggregationSchema() != AggregationSchema.NONE) {
                    Session.ResultSetReader reader = new Session.ResultSetReader(){

                        @Override
                        public void readCurrentRow(ResultSet resultSet) throws SQLException {
                            try {
                                XmlExportTransformer.this.writeEntity(sa.destination, sa, resultSet, ancestors);
                            }
                            catch (SAXException e) {
                                throw new RuntimeException(e);
                            }
                            catch (ParserConfigurationException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        @Override
                        public void close() {
                        }
                    };
                    try {
                        XmlExportTransformer.this.xmlRowWriter.startList(sa);
                        XmlExportTransformer.this.entityGraph.readDependentEntities(sa.destination, sa, resultSet, XmlExportTransformer.this.getMetaData(resultSet), reader, XmlExportTransformer.this.getTypeCache(sa.destination), XmlExportTransformer.this.getTableMapping((Table)sa.destination).selectionSchema, XmlExportTransformer.this.getTableMapping((Table)sa.destination).originalPKAliasPrefix);
                        if (XmlExportTransformer.this.cyclicAggregatedTables.contains(sa.destination)) {
                            XmlExportTransformer.this.entityGraph.markDependentEntitiesAsTraversed(sa, resultSet, XmlExportTransformer.this.getMetaData(resultSet), XmlExportTransformer.this.getTypeCache(sa.destination));
                        }
                        XmlExportTransformer.this.xmlRowWriter.endList(sa);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        ancestors.remove(ancestors.size() - 1);
    }

    private Map<String, Integer> getTypeCache(Table table) {
        Map<String, Integer> cache = this.typeCache.get(table);
        if (cache == null) {
            cache = new HashMap<String, Integer>();
            this.typeCache.put(table, cache);
        }
        return cache;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void endDocument() throws SAXException {
        this.xmlRowWriter.close();
    }

    @Override
    public void close() {
    }

    public TableMapping getTableMapping(Table table) throws ParserConfigurationException, SAXException, IOException {
        if (this.tableMappings.containsKey(table)) {
            return this.tableMappings.get(table);
        }
        TableMapping tableMapping = new TableMapping();
        this.tableMappings.put(table, tableMapping);
        boolean isFiltered = false;
        for (Column c : table.getColumns()) {
            if (c.getFilterExpression() == null) continue;
            isFiltered = true;
            break;
        }
        if (isFiltered) {
            int i = 0;
            while (true) {
                tableMapping.originalPKAliasPrefix = "O" + i;
                boolean found = false;
                for (Column c : table.getColumns()) {
                    if (!c.name.startsWith(tableMapping.originalPKAliasPrefix)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                ++i;
            }
        }
        try {
            tableMapping.template = table.getXmlTemplateAsDocument();
        }
        catch (Exception e) {
            _log.warn("can't parse XML template for table " + table.getName() + ", using defaults", e);
            tableMapping.template = table.getDefaultXmlTemplate();
        }
        final StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Column pk : table.primaryKey.getColumns()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (tableMapping.originalPKAliasPrefix != null) {
                sb.append("T." + tableMapping.originalPKAliasPrefix + i + " AS PK" + i);
                ++i;
                continue;
            }
            sb.append("T." + pk.name + " AS PK" + i++);
        }
        XmlUtil.visitDocumentNodes(tableMapping.template, new NodeVisitor(){
            int nr = 0;

            private void appendSchema(String text) {
                if (text != null && text.startsWith("SQL:")) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(text.substring("SQL:".length()) + " AS C" + this.nr++);
                }
            }

            @Override
            public void visitAssociationElement(String associationName) {
            }

            @Override
            public void visitComment(String comment) {
            }

            @Override
            public void visitElementEnd(String elementName, boolean isRoot) {
            }

            @Override
            public void visitText(String text) {
                this.appendSchema(text);
            }

            @Override
            public void visitElementStart(String elementName, boolean isRoot, String[] attributeNames, String[] attributeValues) {
                for (String value : attributeValues) {
                    this.appendSchema(value);
                }
            }
        });
        tableMapping.selectionSchema = sb.toString();
        return tableMapping;
    }

    static {
        _log = Logger.getLogger(SqlScriptExecutor.class);
    }

    public class TableMapping {
        public Document template;
        public String selectionSchema;
        public String originalPKAliasPrefix;
    }
}

