/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.util.CsvFile;

public class SqlUtil {
    public static final List<String> JAILER_TABLES = new ArrayList<String>();
    public static final List<String> JAILER_MH_TABLES;
    public static DateFormat defaultTimestampFormat;
    public static DateFormat defaultDateFormat;
    public static DBMS dbms;
    private static final char[] hexChar;
    private static final int TYPE_HSTORE = 10500;
    public static final String LETTERS_AND_DIGITS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";
    public static final Map<Integer, String> SQL_TYPE;

    public static String reversRestrictionCondition(String condition) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        StringBuffer reversed = new StringBuffer("");
        for (int i = 0; i < condition.length(); ++i) {
            char c = condition.charAt(i);
            if (!(c != 'A' && c != 'B' && c != 'a' && c != 'b' || i + 1 >= condition.length() || condition.charAt(i + 1) != '.' || i != 0 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_".indexOf(condition.charAt(i - 1)) >= 0)) {
                reversed.append((char)(c == 'A' || c == 'a' ? 66 : 65));
                continue;
            }
            reversed.append(c);
        }
        return reversed.toString();
    }

    public static String replaceAliases(String condition, String aliasA, String aliasB) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < condition.length(); ++i) {
            char c = condition.charAt(i);
            if (!(c != 'A' && c != 'B' && c != 'a' && c != 'b' || i + 1 >= condition.length() || condition.charAt(i + 1) != '.' || i != 0 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_".indexOf(condition.charAt(i - 1)) >= 0)) {
                String alias;
                String string = alias = c == 'A' || c == 'a' ? aliasA : aliasB;
                if (alias == null) {
                    ++i;
                    continue;
                }
                result.append(alias);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String replaceAlias(String condition, String alias) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < condition.length(); ++i) {
            char c = condition.charAt(i);
            if (!(c != 'T' && c != 't' || i + 1 >= condition.length() || condition.charAt(i + 1) != '.' || i != 0 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_".indexOf(condition.charAt(i - 1)) >= 0)) {
                result.append(alias);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String resolvePseudoColumns(String condition, String entityAAlias, String entityBAlias, int today, int birthdayOfSubject) {
        return SqlUtil.resolvePseudoColumns(condition, entityAAlias, entityBAlias, today, birthdayOfSubject, "birthday");
    }

    public static String resolvePseudoColumns(String condition, String entityAAlias, String entityBAlias, int today, int birthdayOfSubject, String birthdayColumnName) {
        String aBirthday = entityAAlias == null ? "" + (today - birthdayOfSubject) : "(" + entityAAlias + "." + birthdayColumnName + " - " + birthdayOfSubject + ")";
        String bBirthday = entityBAlias == null ? "" + (today - birthdayOfSubject) : "(" + entityBAlias + "." + birthdayColumnName + " - " + birthdayOfSubject + ")";
        String aIsSubject = entityAAlias == null ? "(" + (today - birthdayOfSubject) + " = 0)" : "(" + entityAAlias + "." + birthdayColumnName + " - " + birthdayOfSubject + " = 0)";
        String bIsSubject = entityBAlias == null ? "(" + (today - birthdayOfSubject) + " = 0)" : "(" + entityBAlias + "." + birthdayColumnName + " - " + birthdayOfSubject + " = 0)";
        condition = condition.replaceAll("(A|a) *\\. *\\$distance", aBirthday);
        condition = condition.replaceAll("(A|a) *\\. *\\$DISTANCE", aBirthday);
        condition = condition.replaceAll("(B|b) *\\. *\\$distance", bBirthday);
        condition = condition.replaceAll("(B|b) *\\. *\\$DISTANCE", bBirthday);
        condition = condition.replaceAll("(A|a) *\\. *\\$IS_SUBJECT", aIsSubject);
        condition = condition.replaceAll("(A|a) *\\. *\\$is_subject", aIsSubject);
        condition = condition.replaceAll("(B|b) *\\. *\\$IS_SUBJECT", bIsSubject);
        condition = condition.replaceAll("(B|b) *\\. *\\$is_subject", bIsSubject);
        return condition;
    }

    public static Set<Table> readTableList(CsvFile tableFile, DataModel dataModel, Map<String, String> sourceSchemaMapping) {
        HashSet<Table> tabuTables = new HashSet<Table>();
        if (tableFile != null) {
            for (CsvFile.Line line : tableFile.getLines()) {
                String name = SqlUtil.mappedSchema(sourceSchemaMapping, line.cells.get(0));
                Table table = dataModel.getTable(name);
                if (table == null) {
                    throw new RuntimeException(line.location + ": unknown table: '" + name + "'");
                }
                tabuTables.add(table);
            }
        }
        return tabuTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toSql(Object content, Session session) {
        if (content == null) {
            return "null";
        }
        Configuration c = Configuration.forDbms(session);
        if (content instanceof Date) {
            if (c.useToTimestampFunction) {
                String format;
                DateFormat dateFormat = defaultDateFormat;
                synchronized (dateFormat) {
                    format = defaultDateFormat.format((java.util.Date)content);
                }
                return "to_date('" + format + "', 'YYYY-MM-DD')";
            }
            if (c.dateFormat != null) {
                SimpleDateFormat format = c.dateFormat;
                synchronized (format) {
                    return "'" + c.dateFormat.format((java.util.Date)content) + "'";
                }
            }
            return "'" + content + "'";
        }
        if (content instanceof Timestamp) {
            if (c.useToTimestampFunction) {
                String nanoFormat;
                String format;
                DateFormat dateFormat = defaultTimestampFormat;
                synchronized (dateFormat) {
                    format = defaultTimestampFormat.format((java.util.Date)content);
                    String nanoString = SqlUtil.getNanoString((Timestamp)content, c.appendNanosToTimestamp, c.nanoSep);
                    nanoFormat = "FF" + (nanoString.length() - 1);
                    format = format + nanoString;
                }
                return "to_timestamp('" + format + "', 'YYYY-MM-DD HH24.MI.SS." + nanoFormat + "')";
            }
            if (c.timestampFormat != null) {
                String format;
                DateFormat nanoFormat = c.timestampFormat;
                synchronized (nanoFormat) {
                    format = c.timestampFormat.format((java.util.Date)content);
                    if (c.appendMillisToTimestamp) {
                        format = format + SqlUtil.getNanoString((Timestamp)content, c.appendNanosToTimestamp, c.nanoSep);
                    }
                }
                content = format;
            }
            if (c.timestampPattern != null) {
                return c.timestampPattern.replace("%s", "'" + content + "'");
            }
            return "'" + content + "'";
        }
        if (content instanceof NCharWrapper) {
            String prefix = Configuration.forDbms(session).getNcharPrefix();
            if (prefix == null) {
                prefix = "";
            }
            return prefix + "'" + Configuration.forDbms(session).convertToStringLiteral(content.toString()) + "'";
        }
        if (content instanceof String) {
            return "'" + Configuration.forDbms(session).convertToStringLiteral((String)content) + "'";
        }
        if (content instanceof HStoreWrapper) {
            return "'" + Configuration.forDbms(session).convertToStringLiteral(content.toString()) + "'::hstore";
        }
        if (content instanceof byte[]) {
            byte[] data = (byte[])content;
            StringBuilder hex = new StringBuilder((data.length + 1) * 2);
            for (byte b : data) {
                hex.append(hexChar[b >> 4 & 0xF]);
                hex.append(hexChar[b & 0xF]);
            }
            return c.binaryPattern.replace("%s", hex);
        }
        if (content instanceof Time) {
            return "'" + content + "'";
        }
        if (dbms == DBMS.POSTGRESQL && content.getClass().getName().endsWith(".PGobject")) {
            return "B'" + content + "'";
        }
        if (content instanceof UUID) {
            if (dbms == DBMS.POSTGRESQL) {
                return "'" + content + "'::uuid";
            }
            return "'" + content + "'";
        }
        if (Configuration.forDbms(session).isIdentityInserts() && content instanceof Boolean) {
            content = Boolean.TRUE.equals(content) ? "1" : "0";
        }
        return content.toString();
    }

    private static String getNanoString(Timestamp timestamp, boolean full, char nanoSep) {
        int truncIndex;
        String zeros = "000000000";
        int nanos = timestamp.getNanos();
        String nanosString = Integer.toString(nanos);
        nanosString = zeros.substring(0, 9 - nanosString.length()) + nanosString;
        char[] nanosChar = new char[nanosString.length()];
        nanosString.getChars(0, nanosString.length(), nanosChar, 0);
        for (truncIndex = 8; truncIndex > 0 && nanosChar[truncIndex] == '0'; --truncIndex) {
        }
        nanosString = nanoSep + new String(nanosChar, 0, truncIndex + 1);
        if (!full && nanosString.length() > 4) {
            return nanosString.substring(0, 4);
        }
        return nanosString;
    }

    public static Object getObject(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int i, Map<Integer, Integer> typeCache) throws SQLException {
        String typeName;
        Integer type = typeCache.get(i);
        if (type == null) {
            try {
                type = resultSetMetaData.getColumnType(i);
                if (dbms == DBMS.ORACLE && type == 91) {
                    type = 93;
                }
                if (dbms == DBMS.POSTGRESQL && "hstore".equalsIgnoreCase(typeName = resultSetMetaData.getColumnTypeName(i))) {
                    type = 10500;
                }
                if (type == 12 && "nvarchar".equalsIgnoreCase(resultSetMetaData.getColumnTypeName(i))) {
                    type = -9;
                }
                if (type == 1 && "nchar".equalsIgnoreCase(resultSetMetaData.getColumnTypeName(i))) {
                    type = -15;
                }
            }
            catch (Exception e) {
                type = 1111;
            }
            typeCache.put(i, type);
        }
        try {
            if (type == 2003) {
                return resultSet.getString(i);
            }
            if (type == 93) {
                return resultSet.getTimestamp(i);
            }
            if (type == 91) {
                if (dbms == DBMS.MySQL && (typeName = resultSetMetaData.getColumnTypeName(i)) != null && typeName.toUpperCase().equals("YEAR")) {
                    int result = resultSet.getInt(i);
                    if (resultSet.wasNull()) {
                        return null;
                    }
                    return result;
                }
                Date date = resultSet.getDate(i);
                return date;
            }
        }
        catch (SQLException e) {
            return resultSet.getString(i);
        }
        Object object = resultSet.getObject(i);
        if ((type == -15 || type == -9) && object instanceof String) {
            object = new NCharWrapper((String)object);
        }
        if (dbms == DBMS.POSTGRESQL) {
            String typeName2;
            if (type == 10500) {
                return new HStoreWrapper(resultSet.getString(i));
            }
            if (object instanceof Boolean && (typeName2 = resultSetMetaData.getColumnTypeName(i)) != null && typeName2.toLowerCase().equals("bit")) {
                final String value = Boolean.TRUE.equals(object) ? "B'1'" : "B'0'";
                return new Object(){

                    public String toString() {
                        return value;
                    }
                };
            }
        }
        return object;
    }

    public static int getColumnType(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int i, Map<Integer, Integer> typeCache) throws SQLException {
        Integer type = typeCache.get(i);
        if (type == null) {
            try {
                type = resultSetMetaData.getColumnType(i);
            }
            catch (Exception e) {
                type = 1111;
            }
            typeCache.put(i, type);
        }
        return type;
    }

    public static int getColumnType(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String columnName, Map<String, Integer> typeCache) throws SQLException {
        Integer type = typeCache.get(columnName);
        if (type == null) {
            try {
                type = 1111;
                for (int i = resultSetMetaData.getColumnCount(); i > 0; --i) {
                    if (!columnName.equalsIgnoreCase(resultSetMetaData.getColumnName(i))) continue;
                    type = resultSetMetaData.getColumnType(i);
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            typeCache.put(columnName, type);
        }
        return type;
    }

    public static Object getObject(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String columnName, Map<String, Integer> typeCache) throws SQLException {
        Integer type = typeCache.get(columnName);
        if (type == null) {
            try {
                type = 1111;
                for (int i = resultSetMetaData.getColumnCount(); i > 0; --i) {
                    if (!columnName.equalsIgnoreCase(resultSetMetaData.getColumnName(i))) continue;
                    type = resultSetMetaData.getColumnType(i);
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            typeCache.put(columnName, type);
        }
        if (type == 93) {
            return resultSet.getTimestamp(columnName);
        }
        if (type == 91) {
            Date date = resultSet.getDate(columnName);
            return date;
        }
        return resultSet.getObject(columnName);
    }

    public static String mappedSchema(Map<String, String> schemaMapping, String tableName) {
        if (schemaMapping == null) {
            return tableName;
        }
        Table t = new Table(tableName, null, false);
        String schema = t.getOriginalSchema("");
        String mappedSchema = schemaMapping.get(schema);
        if (mappedSchema != null) {
            schema = mappedSchema;
        }
        if (schema.length() == 0) {
            return t.getUnqualifiedName();
        }
        return schema + "." + t.getUnqualifiedName();
    }

    public static String splitDMLStatement(String sql, int maxLength) {
        if (sql.length() <= maxLength) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        int lastBreak = -1;
        int currentLength = 0;
        boolean inLiteral = false;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (currentLength >= maxLength) {
                if (inLiteral && lastBreak <= 0) {
                    if (i + 1 < sql.length() && sql.charAt(i + 1) != '\'') {
                        sb.append("'||\n'");
                        currentLength = 3;
                        lastBreak = -1;
                    }
                } else if (lastBreak > 0) {
                    sb.insert(lastBreak + 1, "\n");
                    currentLength = sb.length() - lastBreak - 2;
                    lastBreak = -1;
                }
            }
            if (!(inLiteral || c != ' ' && c != ',')) {
                lastBreak = sb.length();
            } else if (c == '\n') {
                currentLength = 0;
                lastBreak = -1;
            }
            ++currentLength;
            sb.append(c);
            if (c != '\'') continue;
            inLiteral = !inLiteral;
        }
        return sb.toString();
    }

    static {
        JAILER_TABLES.add("JAILER_GRAPH");
        JAILER_TABLES.add("JAILER_SET");
        JAILER_TABLES.add("JAILER_ENTITY");
        JAILER_TABLES.add("JAILER_DEPENDENCY");
        JAILER_TABLES.add("JAILER_CONFIG");
        JAILER_TABLES.add("JAILER_DUAL");
        JAILER_TABLES.add("JAILER_TMP");
        JAILER_MH_TABLES = new ArrayList<String>();
        JAILER_MH_TABLES.add("JAILER_GRAPH");
        JAILER_MH_TABLES.add("JAILER_SET");
        JAILER_MH_TABLES.add("JAILER_ENTITY");
        JAILER_MH_TABLES.add("JAILER_DEPENDENCY");
        JAILER_MH_TABLES.add("JAILER_CONFIG");
        defaultTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
        defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        SQL_TYPE = new HashMap<Integer, String>();
        SQL_TYPE.put(-5, "BIGINT");
        SQL_TYPE.put(-2, "BINARY");
        SQL_TYPE.put(-7, "BIT");
        SQL_TYPE.put(1, "CHAR");
        SQL_TYPE.put(91, "DATE");
        SQL_TYPE.put(3, "DECIMAL");
        SQL_TYPE.put(8, "DOUBLE");
        SQL_TYPE.put(6, "FLOAT");
        SQL_TYPE.put(4, "INTEGER");
        SQL_TYPE.put(2, "NUMERIC");
        SQL_TYPE.put(92, "TIME");
        SQL_TYPE.put(93, "TIMESTAMP");
        SQL_TYPE.put(-6, "TINYINT");
        SQL_TYPE.put(12, "VARCHAR");
        SQL_TYPE.put(5, "SMALLINT");
        SQL_TYPE.put(2005, "CLOB");
        SQL_TYPE.put(2004, "BLOB");
    }

    static class NCharWrapper {
        private final String value;

        public NCharWrapper(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    static class HStoreWrapper {
        private final String value;

        public HStoreWrapper(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

