/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.database.Session;
import net.sf.jailer.util.Base64;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.Pair;
import org.apache.log4j.Logger;

public class SqlScriptExecutor {
    public static final String UNFINISHED_MULTILINE_COMMENT = "--+";
    public static final String FINISHED_MULTILINE_COMMENT = "--.";
    private static final Logger _log = Logger.getLogger(SqlScriptExecutor.class);
    private static Pair<Integer, Long> lastRowCount = null;

    public static Pair<Integer, Long> executeScript(String scriptFileName, Session session, boolean transactional) throws IOException, SQLException {
        if (!transactional) {
            SqlScriptExecutor.executeScript(scriptFileName, session);
            return new Pair<Integer, Long>(0, 0L);
        }
        try {
            Pair<Integer, Long> r = SqlScriptExecutor.executeScript(scriptFileName, session);
            session.commitAll();
            return r;
        }
        catch (IOException e) {
            session.rollbackAll();
            throw e;
        }
        catch (SQLException e) {
            session.rollbackAll();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Integer, Long> executeScript(String scriptFileName, Session session) throws IOException, SQLException {
        String line;
        BufferedReader bufferedReader;
        _log.info("reading file '" + scriptFileName + "'");
        long fileSize = 0L;
        File file = CommandLineParser.getInstance().newFile(scriptFileName);
        FileInputStream inputStream = new FileInputStream(file);
        Charset encoding = Charset.defaultCharset();
        Charset uTF8 = null;
        try {
            uTF8 = Charset.forName("UTF8");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (uTF8 != null) {
            bufferedReader = scriptFileName.toLowerCase().endsWith(".gz") || scriptFileName.toLowerCase().endsWith(".zip") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(inputStream), uTF8), 1) : new BufferedReader(new InputStreamReader((InputStream)inputStream, uTF8), 1);
            line = bufferedReader.readLine();
            if (line != null && line.contains("encoding UTF-8")) {
                encoding = uTF8;
            }
            bufferedReader.close();
        }
        inputStream = new FileInputStream(file);
        if (scriptFileName.toLowerCase().endsWith(".gz") || scriptFileName.toLowerCase().endsWith(".zip")) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(inputStream), encoding));
        } else {
            fileSize = file.length();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, encoding));
        }
        line = null;
        StringBuffer currentStatement = new StringBuffer();
        long linesRead = 0L;
        long totalRowCount = 0L;
        long bytesRead = 0L;
        long t = System.currentTimeMillis();
        int count = 0;
        LineReader lineReader = new LineReader(bufferedReader);
        while ((line = lineReader.readLine()) != null) {
            bytesRead += (long)(line.length() + 1);
            if ((line = line.trim()).length() == 0 || line.startsWith("--")) {
                if (!line.startsWith(UNFINISHED_MULTILINE_COMMENT)) continue;
                String cmd = line.substring(UNFINISHED_MULTILINE_COMMENT.length());
                if (cmd.startsWith("XML")) {
                    SqlScriptExecutor.importSQLXML(cmd.substring(3).trim(), lineReader, session);
                }
                if (cmd.startsWith("CLOB")) {
                    SqlScriptExecutor.importCLob(cmd.substring(4).trim(), lineReader, session);
                }
                if (!cmd.startsWith("BLOB")) continue;
                SqlScriptExecutor.importBLob(cmd.substring(4).trim(), lineReader, session);
                continue;
            }
            if (line.endsWith(";")) {
                boolean silent;
                block20: {
                    currentStatement.append(line.substring(0, line.length() - 1));
                    String stmt = currentStatement.toString();
                    silent = session.getSilent();
                    session.setSilent(silent || stmt.trim().toLowerCase().startsWith("drop"));
                    try {
                        if (stmt.trim().length() > 0) {
                            totalRowCount += session.execute(stmt);
                            ++linesRead;
                            ++count;
                        }
                    }
                    catch (SQLException e) {
                        if (stmt.trim().toLowerCase().startsWith("drop") || stmt.trim().toUpperCase().contains("DROP TABLE JAILER_DUAL")) break block20;
                        throw e;
                    }
                }
                session.setSilent(silent);
                currentStatement.setLength(0);
                if (System.currentTimeMillis() > t + 1000L) {
                    t = System.currentTimeMillis();
                    long p = 0L;
                    if (fileSize > 0L && (p = 100L * bytesRead / fileSize) > 100L) {
                        p = 100L;
                    }
                    _log.info(linesRead + " statements" + (p > 0L ? " (" + p + "%)" : ""));
                }
            } else {
                currentStatement.append(line + " ");
            }
            CancellationHandler.checkForCancellation(null);
        }
        bufferedReader.close();
        _log.info(linesRead + " statements (100%)");
        _log.info("successfully read file '" + scriptFileName + "'");
        Pair<Integer, Long> r = new Pair<Integer, Long>(count, totalRowCount);
        Class<SqlScriptExecutor> clazz = SqlScriptExecutor.class;
        synchronized (SqlScriptExecutor.class) {
            lastRowCount = r;
            // ** MonitorExit[var22_19] (shouldn't be in output)
            return r;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void importCLob(String clobLocator, LineReader lineReader, Session session) throws IOException, SQLException {
        int c1 = clobLocator.indexOf(44);
        int c2 = clobLocator.indexOf(44, c1 + 1);
        String table = clobLocator.substring(0, c1).trim();
        String column = clobLocator.substring(c1 + 1, c2).trim();
        String where = clobLocator.substring(c2 + 1).trim();
        File lobFile = CommandLineParser.getInstance().newFile("lob." + System.currentTimeMillis());
        FileWriter out = new FileWriter(lobFile);
        long length = 0L;
        block0: while (true) {
            String line;
            if ((line = lineReader.readLine()) == null || !line.startsWith(UNFINISHED_MULTILINE_COMMENT)) {
                ((Writer)out).close();
                session.insertClob(table, column, where, lobFile, length);
                lobFile.delete();
                return;
            }
            String content = line.substring(UNFINISHED_MULTILINE_COMMENT.length());
            int l = content.length();
            boolean inEscape = false;
            int i = 0;
            while (true) {
                block10: {
                    int c;
                    block9: {
                        block7: {
                            block8: {
                                if (i >= l) continue block0;
                                c = content.charAt(i);
                                if (c != 92) break block7;
                                if (!inEscape) break block8;
                                inEscape = false;
                                break block9;
                            }
                            inEscape = true;
                            break block10;
                        }
                        if (inEscape) {
                            if (c == 110) {
                                c = 10;
                            } else if (c == 114) {
                                c = 13;
                            }
                            inEscape = false;
                        }
                    }
                    ((Writer)out).write(c);
                    ++length;
                }
                ++i;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void importSQLXML(String xmlLocator, LineReader lineReader, Session session) throws IOException, SQLException {
        int c1 = xmlLocator.indexOf(44);
        int c2 = xmlLocator.indexOf(44, c1 + 1);
        String table = xmlLocator.substring(0, c1).trim();
        String column = xmlLocator.substring(c1 + 1, c2).trim();
        String where = xmlLocator.substring(c2 + 1).trim();
        File lobFile = CommandLineParser.getInstance().newFile("lob." + System.currentTimeMillis());
        FileWriter out = new FileWriter(lobFile);
        long length = 0L;
        block0: while (true) {
            String line;
            if ((line = lineReader.readLine()) == null || !line.startsWith(UNFINISHED_MULTILINE_COMMENT)) {
                ((Writer)out).close();
                session.insertSQLXML(table, column, where, lobFile, length);
                lobFile.delete();
                return;
            }
            String content = line.substring(UNFINISHED_MULTILINE_COMMENT.length());
            int l = content.length();
            boolean inEscape = false;
            int i = 0;
            while (true) {
                block10: {
                    int c;
                    block9: {
                        block7: {
                            block8: {
                                if (i >= l) continue block0;
                                c = content.charAt(i);
                                if (c != 92) break block7;
                                if (!inEscape) break block8;
                                inEscape = false;
                                break block9;
                            }
                            inEscape = true;
                            break block10;
                        }
                        if (inEscape) {
                            if (c == 110) {
                                c = 10;
                            } else if (c == 114) {
                                c = 13;
                            }
                            inEscape = false;
                        }
                    }
                    ((Writer)out).write(c);
                    ++length;
                }
                ++i;
            }
            break;
        }
    }

    private static void importBLob(String clobLocator, LineReader lineReader, Session session) throws IOException, SQLException {
        String line;
        int c1 = clobLocator.indexOf(44);
        int c2 = clobLocator.indexOf(44, c1 + 1);
        String table = clobLocator.substring(0, c1).trim();
        String column = clobLocator.substring(c1 + 1, c2).trim();
        String where = clobLocator.substring(c2 + 1).trim();
        File lobFile = CommandLineParser.getInstance().newFile("lob." + System.currentTimeMillis());
        FileOutputStream out = new FileOutputStream(lobFile);
        while ((line = lineReader.readLine()) != null && (line = line.trim()).startsWith(UNFINISHED_MULTILINE_COMMENT)) {
            String content = line.substring(UNFINISHED_MULTILINE_COMMENT.length());
            ((OutputStream)out).write(Base64.decode(content));
        }
        ((OutputStream)out).close();
        session.insertBlob(table, column, where, lobFile);
        lobFile.delete();
    }

    public static synchronized Pair<Integer, Long> getLastStatementCount() {
        if (lastRowCount != null) {
            return lastRowCount;
        }
        return new Pair<Integer, Long>(0, 0L);
    }

    private static class LineReader {
        private final BufferedReader reader;
        private boolean eofRead = false;

        public LineReader(BufferedReader reader) {
            this.reader = reader;
        }

        public String readLine() throws IOException {
            String line = this.reader.readLine();
            if (line == null && !this.eofRead) {
                this.eofRead = true;
                return ";";
            }
            return line;
        }
    }
}

