/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Quoting {
    private String quote = null;
    private final boolean unquotedIdentifierInUpperCase;
    private final boolean unquotedIdentifierInMixedCase;
    private Map<String, Set<String>> keyWordsMap = new HashMap<String, Set<String>>();
    private Set<String> keyWords = new HashSet<String>();

    public Quoting(DatabaseMetaData metaData) throws SQLException {
        String quoteString = metaData.getIdentifierQuoteString();
        if (quoteString != null && (quoteString.equals(" ") || quoteString.equals(""))) {
            quoteString = null;
        }
        try {
            String productName = metaData.getDatabaseProductName();
            if (productName != null && productName.toUpperCase().contains("ADAPTIVE SERVER")) {
                quoteString = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.quote = quoteString;
        this.unquotedIdentifierInUpperCase = metaData.storesUpperCaseIdentifiers();
        this.unquotedIdentifierInMixedCase = metaData.storesMixedCaseIdentifiers();
        String k = metaData.getSQLKeywords();
        if (k != null) {
            this.keyWords = this.keyWordsMap.get(k);
            if (this.keyWords == null) {
                this.keyWords = new HashSet<String>();
                for (String key : k.split(",")) {
                    this.keyWords.add(key.trim().toUpperCase());
                }
                this.keyWords.addAll(Arrays.asList("ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTAINS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DETERMINISTIC", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "ELSE", "ELSEIF", "END", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HANDLER", "HAVING", "HOUR", "IDENTITY", "IF", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEAVE", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOOP", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUT", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARAMETER", "PARTIAL", "PATH", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "REPEAT", "RESIGNAL", "RESTRICT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROUTINE", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIGNAL", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SQL", "SQLCODE", "SQLERROR", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNDO", "UNION", "UNIQUE", "UNKNOWN", "UNTIL", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"));
                this.keyWordsMap.put(k, this.keyWords);
            }
        }
    }

    public String quote(String identifier) {
        if (identifier != null) {
            identifier = identifier.trim();
        }
        if (this.quote != null && identifier != null && identifier.length() > 0) {
            if (!this.keyWords.contains(identifier.toUpperCase())) {
                String lower = "abcdefghijklmnopqrstuvwxyz_0123456789";
                String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";
                String digits = "0123456789";
                boolean allUpperCase = true;
                boolean allLowerCase = true;
                boolean allLetters = true;
                for (int i = identifier.length() - 1; i >= 0; --i) {
                    char c = identifier.charAt(i);
                    if (lower.indexOf(c) < 0) {
                        allLowerCase = false;
                    }
                    if (upper.indexOf(c) < 0) {
                        allUpperCase = false;
                    }
                    if (lower.indexOf(c) >= 0 || upper.indexOf(c) >= 0 || digits.indexOf(c) >= 0) continue;
                    allLetters = false;
                }
                if (digits.indexOf(identifier.charAt(0)) < 0) {
                    if (this.unquotedIdentifierInMixedCase && allLetters) {
                        return identifier;
                    }
                    if (this.unquotedIdentifierInUpperCase && allUpperCase) {
                        return identifier;
                    }
                    if (!this.unquotedIdentifierInUpperCase && allLowerCase) {
                        return identifier;
                    }
                }
            }
            return this.quote + identifier + this.quote;
        }
        return identifier;
    }

    public String unquote(String identifier) {
        if (this.quote != null && identifier != null && identifier.startsWith(this.quote) && identifier.endsWith(this.quote)) {
            return identifier.substring(this.quote.length(), identifier.length() - this.quote.length());
        }
        return identifier;
    }
}

