/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.datamodel.Table;

public class PrintUtil {
    private static Map<String, String> templateCache = new HashMap<String, String>();

    public static String tableSetAsString(Set<Table> tables) {
        return PrintUtil.tableSetAsString(tables, "      ");
    }

    public static String tableSetAsString(Set<Table> tables, String linePrefix) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table table : tables) {
            tableNames.add(table.getName());
        }
        Collections.sort(tableNames);
        StringBuffer str = new StringBuffer();
        str.append(" { ");
        int i = 1;
        for (String tableName : tableNames) {
            if (i > 1) {
                str.append(", ");
            }
            if (i % 5 == 0 && linePrefix != null) {
                str.append("\n" + linePrefix);
            }
            str.append(tableName);
            ++i;
        }
        str.append(" }");
        return str.toString();
    }

    public static String applyTemplate(String template, Object[] arguments) throws FileNotFoundException, IOException {
        String sb = templateCache.get(template);
        if (sb == null) {
            sb = PrintUtil.loadFile(template);
            templateCache.put(template, sb);
        }
        return MessageFormat.format(sb, arguments);
    }

    public static String applyTemplate(String template, Map<String, String> arguments, Map<String, List<String>> listArguments) throws FileNotFoundException, IOException {
        String sb = templateCache.get(template);
        if (sb == null) {
            sb = PrintUtil.loadFile(template);
            templateCache.put(template, sb);
        }
        for (Map.Entry<String, String> e : arguments.entrySet()) {
            sb = sb.replaceAll("\\$\\{" + e.getKey() + "\\}", e.getValue());
        }
        while (true) {
            int begin = sb.indexOf("${for-each:");
            int end = sb.indexOf("${end}");
            if (begin < 0 || end < 0) break;
            String pre = sb.substring(0, begin);
            String woPre = sb.substring(begin + 11);
            int i = woPre.indexOf(125);
            String content = woPre.substring(i + 1, end - begin - 11);
            String suf = sb.substring(end + 6);
            String cContent = "";
            int index = 1;
            for (String var : listArguments.get(woPre.substring(0, i))) {
                cContent = cContent + content.replaceAll("\\$i", "" + index++).replaceAll("\\$", var);
            }
            sb = pre + cContent + suf;
        }
        return sb;
    }

    public static String loadFile(String file) throws FileNotFoundException, IOException {
        return PrintUtil.loadFile(file, false);
    }

    public static String loadFile(String file, boolean ignoreComments) throws FileNotFoundException, IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(CommandLineParser.getInstance().newFile(file)));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (ignoreComments && (line.trim().length() <= 0 || line.startsWith("#"))) continue;
            sb.append(line + "\n");
        }
        reader.close();
        return sb.toString();
    }
}

