/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.jailer.util.CancellationException;
import org.apache.log4j.Logger;

public class JobManager {
    private static final Logger _log = Logger.getLogger(JobManager.class);
    private final List<JobRunner> runnersList;
    private int jobsDoneCounter;
    private int jobsInExecutionCounter;
    private List<Job> jobs;
    private Exception exception;

    public JobManager(int threads) {
        this.runnersList = new ArrayList<JobRunner>(threads);
        for (int i = 0; i < threads; ++i) {
            JobRunner jobRunner = new JobRunner();
            this.runnersList.add(jobRunner);
            String threadName = "job-runner " + (i + 1);
            _log.debug("starting " + threadName);
            Thread thread = new Thread((Runnable)jobRunner, threadName);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public void executeJobs(Collection<Job> jobs) throws Exception {
        int jobCount = jobs.size();
        _log.info("starting " + jobCount + " jobs");
        if (this.runnersList.size() == 1) {
            for (Job job : jobs) {
                job.run();
            }
        } else {
            this.setJobs(new LinkedList<Job>(jobs));
            while (this.getJobsDoneCounter() < jobCount || this.getJobsInExecutionCounter() > 0) {
                Thread.sleep(100L);
                Exception e = this.getException();
                if (e == null) continue;
                if (!(e instanceof CancellationException)) {
                    _log.error("Job-error", e);
                }
                while (this.getJobsInExecutionCounter() > 0) {
                    Thread.sleep(50L);
                }
                throw e;
            }
        }
        _log.info("executed " + jobCount + " jobs");
    }

    public void shutdown() {
        for (int i = 0; i < this.runnersList.size(); ++i) {
            String threadName = "job-runner " + (i + 1);
            _log.debug("shutting down " + threadName);
            this.runnersList.get(i).shutdown();
        }
    }

    private synchronized void setJobs(List<Job> jobs) {
        this.jobsDoneCounter = 0;
        this.jobsInExecutionCounter = 0;
        this.jobs = jobs;
        this.exception = null;
    }

    private synchronized int getJobsDoneCounter() {
        return this.jobsDoneCounter;
    }

    private synchronized void incrementJobsDoneCounter() {
        ++this.jobsDoneCounter;
    }

    private synchronized int getJobsInExecutionCounter() {
        return this.jobsInExecutionCounter;
    }

    private synchronized void incrementJobsInExecutionCounter() {
        ++this.jobsInExecutionCounter;
    }

    private synchronized void decrementJobsInExecutionCounter() {
        --this.jobsInExecutionCounter;
    }

    private synchronized Exception getException() {
        return this.exception;
    }

    private synchronized Job nextJob() {
        if (this.jobs != null && !this.jobs.isEmpty()) {
            return this.jobs.remove(0);
        }
        return null;
    }

    private synchronized void setException(Exception e) {
        this.exception = e == null ? null : (e instanceof CancellationException ? e : new RuntimeException(Thread.currentThread().getName() + " failed", e));
        this.jobs = null;
    }

    private class JobRunner
    implements Runnable {
        private boolean isRunning = true;

        private JobRunner() {
        }

        public synchronized void shutdown() {
            this.isRunning = false;
        }

        public synchronized boolean isRunning() {
            return this.isRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            _log.debug("start up");
            while (this.isRunning()) {
                Job job = JobManager.this.nextJob();
                if (job == null) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                try {
                    JobManager.this.incrementJobsInExecutionCounter();
                    job.run();
                    JobManager.this.incrementJobsDoneCounter();
                }
                catch (Exception e) {
                    JobManager.this.setException(e);
                }
                finally {
                    JobManager.this.decrementJobsInExecutionCounter();
                }
            }
            _log.debug("shutting down");
        }
    }

    public static interface Job {
        public void run() throws Exception;
    }
}

