/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.Pair;

public class CycleFinder {
    public static Collection<Path> findCycle(DataModel dataModel, Collection<Table> tables) {
        HashMap cycles;
        ArrayList<Path> allCycles = new ArrayList<Path>();
        HashSet<Pair<Table, Table>> tabu = new HashSet<Pair<Table, Table>>();
        do {
            tables = CycleFinder.getCycle(tables, tabu);
            TreeMap fromToPaths = new TreeMap();
            for (Table table : tables) {
                ArrayList pathList = new ArrayList(10);
                fromToPaths.put(table, pathList);
            }
            for (Table table : tables) {
                for (Association association : table.associations) {
                    if (!association.isInsertDestinationBeforeSource() || !tables.contains(association.destination)) continue;
                    Path path = new Path(association.source, association.destination, null, null, 0);
                    ((List)fromToPaths.get(path.from)).add(path);
                }
            }
            ArrayList<Path> newPaths = new ArrayList<Path>();
            TreeSet tSet = new TreeSet();
            int today = 1;
            while (true) {
                newPaths.clear();
                int yesterday = today - 1;
                for (Map.Entry e : fromToPaths.entrySet()) {
                    for (Path path : (List)e.getValue()) {
                        List list;
                        CancellationHandler.checkForCancellation(null);
                        if (path.from == path.to || (list = (List)fromToPaths.get(path.to)) == null) continue;
                        for (Path toAppend : list) {
                            if (toAppend.from == toAppend.to || toAppend.birthday != yesterday) continue;
                            Path newPath = new Path(path.from, toAppend.to, path, toAppend, today);
                            if (((List)fromToPaths.get(newPath.from)).contains(newPath)) continue;
                            int aSize = newPath.from == newPath.to ? newPath.length : newPath.length + 1;
                            tSet.clear();
                            newPath.fillSet(tSet);
                            if (tSet.size() != aSize) continue;
                            newPaths.add(newPath);
                        }
                    }
                }
                if (newPaths.isEmpty()) break;
                for (Path path : newPaths) {
                    ((List)fromToPaths.get(path.from)).add(path);
                }
                boolean cycFound = false;
                for (List pList : fromToPaths.values()) {
                    for (Path path : pList) {
                        if (path.from != path.to) continue;
                        cycFound = true;
                        break;
                    }
                    if (!cycFound) continue;
                    break;
                }
                if (cycFound) break;
                ++today;
            }
            cycles = new HashMap();
            long nPath = 0L;
            for (List pList : fromToPaths.values()) {
                CancellationHandler.checkForCancellation(null);
                nPath += (long)pList.size();
                for (Path path : pList) {
                    if (path.from != path.to) continue;
                    ArrayList<Table> pl = new ArrayList<Table>();
                    path.fillPath(pl);
                    for (int i = 0; i < pl.size(); ++i) {
                        tabu.add(new Pair(pl.get(i), pl.get((i + 1) % pl.size())));
                    }
                    TreeSet taSet = new TreeSet();
                    path.fillSet(taSet);
                    cycles.put(taSet, path);
                }
            }
            allCycles.addAll(cycles.values());
        } while (!cycles.isEmpty());
        return allCycles;
    }

    public static Set<Table> getCycle(Collection<Table> tables) {
        return CycleFinder.getCycle(tables, new HashSet<Pair<Table, Table>>());
    }

    private static Set<Table> getCycle(Collection<Table> tables, Set<Pair<Table, Table>> tabu) {
        TreeSet<Table> cycle = new TreeSet<Table>(tables);
        while (true) {
            TreeSet<Table> notInCycle = new TreeSet<Table>();
            for (Table table : cycle) {
                boolean hasIn = false;
                boolean hasOut = false;
                for (Association association : table.associations) {
                    if (!cycle.contains(association.destination)) continue;
                    if (association.isInsertSourceBeforeDestination() && !tabu.contains(new Pair<Table, Table>(association.destination, association.source))) {
                        hasOut = true;
                    }
                    if (!association.isInsertDestinationBeforeSource() || tabu.contains(new Pair<Table, Table>(association.source, association.destination))) continue;
                    hasIn = true;
                }
                if (hasIn && hasOut) continue;
                notInCycle.add(table);
            }
            if (notInCycle.isEmpty()) break;
            cycle.removeAll(notInCycle);
        }
        return cycle;
    }

    public static class Path {
        final Table from;
        final Table to;
        final Path left;
        final Path right;
        final int birthday;
        final int length;

        Path(Table from, Table to, Path left, Path right, int birthday) {
            this.from = from;
            this.to = to;
            this.left = left;
            this.right = right;
            this.birthday = birthday;
            this.length = left == null ? 1 : left.length + right.length;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Path)) {
                return false;
            }
            Path op = (Path)other;
            if (this.from != op.from || this.to != op.to || this.length != op.length) {
                return false;
            }
            TreeSet<Table> p1 = new TreeSet<Table>();
            TreeSet<Table> p2 = new TreeSet<Table>();
            this.fillSet(p1);
            op.fillSet(p2);
            return p1.equals(p2);
        }

        public void fillPath(List<Table> path) {
            if (this.left == null) {
                path.add(this.from);
                path.add(this.to);
            } else {
                this.left.fillPath(path);
                path.remove(path.size() - 1);
                this.right.fillPath(path);
            }
        }

        private void fillSet(Set<Table> set) {
            if (this.left == null) {
                set.add(this.from);
                if (this.to != this.from) {
                    set.add(this.to);
                }
            } else {
                this.left.fillSet(set);
                this.right.fillSet(set);
            }
        }

        public String toString() {
            return "{" + (this.left == null ? this.from.getName() + "->" + this.to.getName() : this.left + "-->" + this.right) + " " + this.birthday + "/" + this.length + "}";
        }
    }
}

