/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class CsvFile {
    private List<Line> rows = new ArrayList<Line>();
    public static String BLOCK_INDICATOR = "#! block ";

    public CsvFile(File csvFile) throws Exception {
        this(csvFile, null, null);
    }

    public CsvFile(File csvFile, LineFilter filter) throws Exception {
        this(csvFile, null, filter);
    }

    public CsvFile(File csvFile, String block) throws Exception {
        this(csvFile, block, null);
    }

    public CsvFile(File csvFile, String block, LineFilter filter) throws Exception {
        boolean inBlock;
        BufferedReader reader = new BufferedReader(new FileReader(csvFile));
        String line = null;
        int lineNr = 0;
        boolean bl = inBlock = block == null;
        while ((line = reader.readLine()) != null) {
            ++lineNr;
            if (line.trim().length() == 0) continue;
            if (line.trim().startsWith(BLOCK_INDICATOR)) {
                if (inBlock) break;
                String blockName = line.trim().substring(BLOCK_INDICATOR.length()).trim();
                inBlock = block.equals(blockName);
                continue;
            }
            if (line.trim().startsWith("#include ")) {
                String includeFile = line.trim().substring(9).trim();
                this.rows.addAll(new CsvFile((File)new File((String)new StringBuilder().append((String)csvFile.getParent()).append((String)File.separator).append((String)includeFile).toString())).rows);
                continue;
            }
            if (line.trim().startsWith("#") || !inBlock) continue;
            ArrayList<String> row = new ArrayList<String>();
            String[] col = CsvFile.decodeLine(line);
            for (int i = 0; i < col.length; ++i) {
                String s = col[i];
                row.add(s.trim());
            }
            while (row.size() < 100) {
                row.add("");
            }
            Line cvsLine = new Line("line " + lineNr + ", file " + csvFile.getName(), row);
            if (filter != null && !filter.accept(cvsLine)) continue;
            this.rows.add(cvsLine);
        }
        reader.close();
    }

    public static String[] decodeLine(String line) {
        ArrayList<String> cells = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean esc = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                if (esc) {
                    esc = false;
                } else {
                    esc = true;
                    continue;
                }
            }
            if (!esc && c == ';') {
                cells.add(sb.toString());
                sb.setLength(0);
            } else {
                if (esc && c == 'n') {
                    c = '\n';
                } else if (esc && c == 'r') {
                    c = '\r';
                }
                sb.append(c);
            }
            esc = false;
        }
        cells.add(sb.toString());
        return cells.toArray(new String[cells.size()]);
    }

    public static String encodeCell(String cell) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cell.length(); ++i) {
            char c = cell.charAt(i);
            if (c == ';') {
                sb.append("\\;");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public List<Line> getLines() {
        return this.rows;
    }

    public boolean contains(String[] line) {
        for (Line l : this.getLines()) {
            boolean differenceFound = false;
            int i = 0;
            for (String cell : line) {
                if (cell != null && !cell.equals(l.cells.get(i))) {
                    differenceFound = true;
                    break;
                }
                ++i;
            }
            if (differenceFound) continue;
            return true;
        }
        return false;
    }

    public static interface LineFilter {
        public boolean accept(Line var1);
    }

    public static class Line {
        public final String location;
        public final List<String> cells;
        public int length;

        public Line(String location, List<String> cells) {
            this.location = location;
            this.cells = cells;
            int num = 0;
            int l = 0;
            for (String s : cells) {
                ++num;
                if (s == null || s.trim().length() <= 0) continue;
                l = num;
            }
            this.length = l;
        }

        public String toString() {
            int num = 0;
            int l = 0;
            for (String s : this.cells) {
                ++num;
                if (s == null || s.trim().length() <= 0) continue;
                l = num;
            }
            StringBuffer sb = new StringBuffer();
            if (l >= this.cells.size()) {
                l = this.cells.size() - 1;
            }
            for (int i = 0; i <= l; ++i) {
                sb.append(CsvFile.encodeCell(this.cells.get(i)) + "; ");
            }
            return sb.toString();
        }
    }
}

