/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClasspathUtil {
    private static final Logger _log = Logger.getLogger(ClasspathUtil.class);
    private static Map<String, URLClassLoader> classloaders = new HashMap<String, URLClassLoader>();

    public static synchronized URLClassLoader addJarToClasspath(String jarName1, String jarName2) throws Exception {
        URL[] urls;
        File file;
        String mapKey = jarName1 + "," + jarName2;
        if (classloaders.containsKey(mapKey)) {
            return classloaders.get(mapKey);
        }
        if (jarName1 == null) {
            if (jarName2 == null) {
                return null;
            }
            jarName1 = jarName2;
            jarName2 = null;
        }
        if (!(file = new File(jarName1)).exists()) {
            throw new FileNotFoundException("Jar-file not found: '" + jarName1 + "'");
        }
        _log.info("added '" + jarName1 + "' to classpath");
        if (jarName2 == null) {
            urls = new URL[]{file.toURI().toURL()};
        } else {
            File file2 = new File(jarName2);
            if (!file2.exists()) {
                throw new FileNotFoundException("Jar-file not found: '" + jarName2 + "'");
            }
            _log.info("added '" + jarName2 + "' to classpath");
            urls = new URL[]{file.toURI().toURL(), file2.toURI().toURL()};
        }
        URLClassLoader urlLoader = new URLClassLoader(urls);
        classloaders.put(mapKey, urlLoader);
        return urlLoader;
    }
}

