/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.util;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jailer.util.CancellationException;
import net.sf.jailer.util.JobManager;
import org.apache.log4j.Logger;

public class CancellationHandler {
    private static Set<Object> cancelled = new HashSet<Object>();
    private static Map<Object, List<Statement>> currentStatements = new HashMap<Object, List<Statement>>();
    private static final Logger _log = Logger.getLogger(JobManager.class);
    private static final Object DEFAULT_CONTEXT = new Object();

    public static synchronized void reset(Object context) {
        cancelled.remove(context == null ? DEFAULT_CONTEXT : context);
        currentStatements.remove(context == null ? DEFAULT_CONTEXT : context);
    }

    public static void cancel(Object context) {
        _log.warn("cancellation request received");
        CancellationHandler.synchronizedCancel(context);
    }

    public static void cancelSilently(Object context) {
        CancellationHandler.synchronizedCancel(context);
    }

    private static synchronized void synchronizedCancel(Object context) {
        cancelled.add(context == null ? DEFAULT_CONTEXT : context);
        if (currentStatements.containsKey(context == null ? DEFAULT_CONTEXT : context)) {
            ArrayList toBeCanceled = new ArrayList(currentStatements.get(context == null ? DEFAULT_CONTEXT : context));
            currentStatements.remove(context == null ? DEFAULT_CONTEXT : context);
            for (final Statement statement : toBeCanceled) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            statement.cancel();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }).start();
            }
        }
    }

    public static synchronized void begin(Statement statement, Object context) {
        CancellationHandler.checkForCancellation(context);
        List<Statement> sl = currentStatements.get(context == null ? DEFAULT_CONTEXT : context);
        if (sl == null) {
            sl = new ArrayList<Statement>();
            currentStatements.put(context == null ? DEFAULT_CONTEXT : context, sl);
        }
        sl.add(statement);
    }

    public static synchronized void end(Statement statement, Object context) {
        if (currentStatements.containsKey(context == null ? DEFAULT_CONTEXT : context)) {
            currentStatements.get(context == null ? DEFAULT_CONTEXT : context).remove(statement);
        }
    }

    public static synchronized void checkForCancellation(Object context) throws CancellationException {
        if (cancelled.contains(context == null ? DEFAULT_CONTEXT : context)) {
            throw new CancellationException();
        }
    }
}

