/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.scrollmenu;

import java.awt.Component;
import java.awt.ComponentOrientation;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;
import net.sf.jailer.ui.scrollmenu.JScrollC2PopupMenu;

public class JScrollC2Menu
extends JMenu {
    private JPopupMenu popupMenu;

    public JScrollC2Menu() {
        this("");
    }

    public JScrollC2Menu(String s) {
        super(s);
    }

    public JScrollC2Menu(Action a) {
        this();
        this.setAction(a);
    }

    protected void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            this.popupMenu = new JScrollC2PopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
        }
    }

    @Override
    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    @Override
    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    @Override
    public void setMenuLocation(int x, int y) {
        super.setMenuLocation(x, y);
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(x, y);
        }
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(menuItem);
    }

    @Override
    public Component add(Component c) {
        this.ensurePopupMenuCreated();
        this.popupMenu.add(c);
        return c;
    }

    @Override
    public Component add(Component c, int index) {
        this.ensurePopupMenuCreated();
        this.popupMenu.add(c, index);
        return c;
    }

    @Override
    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    @Override
    public void insert(String s, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(s), pos);
    }

    @Override
    public JMenuItem insert(JMenuItem mi, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(mi, pos);
        return mi;
    }

    @Override
    public JMenuItem insert(Action a, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem mi = new JMenuItem(a);
        mi.setHorizontalTextPosition(11);
        mi.setVerticalTextPosition(0);
        this.popupMenu.insert(mi, pos);
        return mi;
    }

    @Override
    public void insertSeparator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), index);
    }

    @Override
    public void remove(JMenuItem item) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(item);
        }
    }

    @Override
    public void remove(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (pos > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(pos);
        }
    }

    @Override
    public void remove(Component c) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(c);
        }
    }

    @Override
    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    @Override
    public int getMenuComponentCount() {
        return this.popupMenu == null ? 0 : this.popupMenu.getComponentCount();
    }

    @Override
    public Component getMenuComponent(int n) {
        return this.popupMenu == null ? null : this.popupMenu.getComponent(n);
    }

    @Override
    public Component[] getMenuComponents() {
        return this.popupMenu == null ? new Component[]{} : this.popupMenu.getComponents();
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    @Override
    public MenuElement[] getSubElements() {
        MenuElement[] menuElementArray;
        if (this.popupMenu == null) {
            menuElementArray = new MenuElement[]{};
        } else {
            MenuElement[] menuElementArray2 = new MenuElement[1];
            menuElementArray = menuElementArray2;
            menuElementArray2[0] = this.popupMenu;
        }
        return menuElementArray;
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        if (this.popupMenu != null) {
            int ncomponents = this.getMenuComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                this.getMenuComponent(i).applyComponentOrientation(o);
            }
            this.popupMenu.setComponentOrientation(o);
        }
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        if (this.popupMenu != null) {
            this.popupMenu.setComponentOrientation(o);
        }
    }
}

